<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayTimeCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DayTimeCriterion
 * @subpackage Structs
 */
class DayTimeCriterion extends Criterion
{
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Day;
    /**
     * The FromHour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromHour;
    /**
     * The FromMinute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromMinute;
    /**
     * The ToHour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToHour;
    /**
     * The ToMinute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToMinute;
    /**
     * Constructor method for DayTimeCriterion
     * @uses DayTimeCriterion::setDay()
     * @uses DayTimeCriterion::setFromHour()
     * @uses DayTimeCriterion::setFromMinute()
     * @uses DayTimeCriterion::setToHour()
     * @uses DayTimeCriterion::setToMinute()
     * @param string $day
     * @param int $fromHour
     * @param string $fromMinute
     * @param int $toHour
     * @param string $toMinute
     */
    public function __construct($day = null, $fromHour = null, $fromMinute = null, $toHour = null, $toMinute = null)
    {
        $this
            ->setDay($day)
            ->setFromHour($fromHour)
            ->setFromMinute($fromMinute)
            ->setToHour($toHour)
            ->setToMinute($toMinute);
    }
    /**
     * Get Day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDay()
    {
        return isset($this->Day) ? $this->Day : null;
    }
    /**
     * Set Day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Day::valueIsValid()
     * @uses \EnumType\Day::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $day
     * @return \StructType\DayTimeCriterion
     */
    public function setDay($day = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Day::valueIsValid($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Day', is_array($day) ? implode(', ', $day) : var_export($day, true), implode(', ', \EnumType\Day::getValidValues())), __LINE__);
        }
        if (is_null($day) || (is_array($day) && empty($day))) {
            unset($this->Day);
        } else {
            $this->Day = $day;
        }
        return $this;
    }
    /**
     * Get FromHour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromHour()
    {
        return isset($this->FromHour) ? $this->FromHour : null;
    }
    /**
     * Set FromHour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromHour
     * @return \StructType\DayTimeCriterion
     */
    public function setFromHour($fromHour = null)
    {
        // validation for constraint: int
        if (!is_null($fromHour) && !(is_int($fromHour) || ctype_digit($fromHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromHour, true), gettype($fromHour)), __LINE__);
        }
        if (is_null($fromHour) || (is_array($fromHour) && empty($fromHour))) {
            unset($this->FromHour);
        } else {
            $this->FromHour = $fromHour;
        }
        return $this;
    }
    /**
     * Get FromMinute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromMinute()
    {
        return isset($this->FromMinute) ? $this->FromMinute : null;
    }
    /**
     * Set FromMinute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Minute::valueIsValid()
     * @uses \EnumType\Minute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromMinute
     * @return \StructType\DayTimeCriterion
     */
    public function setFromMinute($fromMinute = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Minute::valueIsValid($fromMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Minute', is_array($fromMinute) ? implode(', ', $fromMinute) : var_export($fromMinute, true), implode(', ', \EnumType\Minute::getValidValues())), __LINE__);
        }
        if (is_null($fromMinute) || (is_array($fromMinute) && empty($fromMinute))) {
            unset($this->FromMinute);
        } else {
            $this->FromMinute = $fromMinute;
        }
        return $this;
    }
    /**
     * Get ToHour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToHour()
    {
        return isset($this->ToHour) ? $this->ToHour : null;
    }
    /**
     * Set ToHour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toHour
     * @return \StructType\DayTimeCriterion
     */
    public function setToHour($toHour = null)
    {
        // validation for constraint: int
        if (!is_null($toHour) && !(is_int($toHour) || ctype_digit($toHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toHour, true), gettype($toHour)), __LINE__);
        }
        if (is_null($toHour) || (is_array($toHour) && empty($toHour))) {
            unset($this->ToHour);
        } else {
            $this->ToHour = $toHour;
        }
        return $this;
    }
    /**
     * Get ToMinute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToMinute()
    {
        return isset($this->ToMinute) ? $this->ToMinute : null;
    }
    /**
     * Set ToMinute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Minute::valueIsValid()
     * @uses \EnumType\Minute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $toMinute
     * @return \StructType\DayTimeCriterion
     */
    public function setToMinute($toMinute = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Minute::valueIsValid($toMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Minute', is_array($toMinute) ? implode(', ', $toMinute) : var_export($toMinute, true), implode(', ', \EnumType\Minute::getValidValues())), __LINE__);
        }
        if (is_null($toMinute) || (is_array($toMinute) && empty($toMinute))) {
            unset($this->ToMinute);
        } else {
            $this->ToMinute = $toMinute;
        }
        return $this;
    }
}
