<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Date StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Date
 * @subpackage Structs
 */
class Date extends AbstractStructBase
{
    /**
     * The Day
     * @var int
     */
    public $Day;
    /**
     * The Month
     * @var int
     */
    public $Month;
    /**
     * The Year
     * @var int
     */
    public $Year;
    /**
     * Constructor method for Date
     * @uses Date::setDay()
     * @uses Date::setMonth()
     * @uses Date::setYear()
     * @param int $day
     * @param int $month
     * @param int $year
     */
    public function __construct($day = null, $month = null, $year = null)
    {
        $this
            ->setDay($day)
            ->setMonth($month)
            ->setYear($year);
    }
    /**
     * Get Day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \StructType\Date
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\Date
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\Date
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
}
