<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CombinationRule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CombinationRule
 * @subpackage Structs
 */
class CombinationRule extends AbstractStructBase
{
    /**
     * The AudienceIds
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AudienceIds;
    /**
     * The Operator
     * @var string
     */
    public $Operator;
    /**
     * Constructor method for CombinationRule
     * @uses CombinationRule::setAudienceIds()
     * @uses CombinationRule::setOperator()
     * @param \ArrayType\ArrayOflong $audienceIds
     * @param string $operator
     */
    public function __construct(\ArrayType\ArrayOflong $audienceIds = null, $operator = null)
    {
        $this
            ->setAudienceIds($audienceIds)
            ->setOperator($operator);
    }
    /**
     * Get AudienceIds value
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAudienceIds()
    {
        return $this->AudienceIds;
    }
    /**
     * Set AudienceIds value
     * @param \ArrayType\ArrayOflong $audienceIds
     * @return \StructType\CombinationRule
     */
    public function setAudienceIds(\ArrayType\ArrayOflong $audienceIds = null)
    {
        $this->AudienceIds = $audienceIds;
        return $this;
    }
    /**
     * Get Operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \EnumType\LogicalOperator::valueIsValid()
     * @uses \EnumType\LogicalOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\CombinationRule
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LogicalOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LogicalOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\LogicalOperator::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
}
