<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignAdGroupIds StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignAdGroupIds
 * @subpackage Structs
 */
class CampaignAdGroupIds extends AbstractStructBase
{
    /**
     * The ActiveAdGroupsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ActiveAdGroupsOnly;
    /**
     * The AdGroupIds
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdGroupIds;
    /**
     * The CampaignId
     * @var int
     */
    public $CampaignId;
    /**
     * Constructor method for CampaignAdGroupIds
     * @uses CampaignAdGroupIds::setActiveAdGroupsOnly()
     * @uses CampaignAdGroupIds::setAdGroupIds()
     * @uses CampaignAdGroupIds::setCampaignId()
     * @param bool $activeAdGroupsOnly
     * @param \ArrayType\ArrayOflong $adGroupIds
     * @param int $campaignId
     */
    public function __construct($activeAdGroupsOnly = null, \ArrayType\ArrayOflong $adGroupIds = null, $campaignId = null)
    {
        $this
            ->setActiveAdGroupsOnly($activeAdGroupsOnly)
            ->setAdGroupIds($adGroupIds)
            ->setCampaignId($campaignId);
    }
    /**
     * Get ActiveAdGroupsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActiveAdGroupsOnly()
    {
        return isset($this->ActiveAdGroupsOnly) ? $this->ActiveAdGroupsOnly : null;
    }
    /**
     * Set ActiveAdGroupsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $activeAdGroupsOnly
     * @return \StructType\CampaignAdGroupIds
     */
    public function setActiveAdGroupsOnly($activeAdGroupsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeAdGroupsOnly) && !is_bool($activeAdGroupsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeAdGroupsOnly, true), gettype($activeAdGroupsOnly)), __LINE__);
        }
        if (is_null($activeAdGroupsOnly) || (is_array($activeAdGroupsOnly) && empty($activeAdGroupsOnly))) {
            unset($this->ActiveAdGroupsOnly);
        } else {
            $this->ActiveAdGroupsOnly = $activeAdGroupsOnly;
        }
        return $this;
    }
    /**
     * Get AdGroupIds value
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdGroupIds()
    {
        return $this->AdGroupIds;
    }
    /**
     * Set AdGroupIds value
     * @param \ArrayType\ArrayOflong $adGroupIds
     * @return \StructType\CampaignAdGroupIds
     */
    public function setAdGroupIds(\ArrayType\ArrayOflong $adGroupIds = null)
    {
        $this->AdGroupIds = $adGroupIds;
        return $this;
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\CampaignAdGroupIds
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
}
