<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallAdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CallAdExtension
 * @subpackage Structs
 */
class CallAdExtension extends AdExtension
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The IsCallOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCallOnly;
    /**
     * The IsCallTrackingEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCallTrackingEnabled;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RequireTollFreeTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequireTollFreeTrackingNumber;
    /**
     * Constructor method for CallAdExtension
     * @uses CallAdExtension::setCountryCode()
     * @uses CallAdExtension::setIsCallOnly()
     * @uses CallAdExtension::setIsCallTrackingEnabled()
     * @uses CallAdExtension::setPhoneNumber()
     * @uses CallAdExtension::setRequireTollFreeTrackingNumber()
     * @param string $countryCode
     * @param bool $isCallOnly
     * @param bool $isCallTrackingEnabled
     * @param string $phoneNumber
     * @param bool $requireTollFreeTrackingNumber
     */
    public function __construct($countryCode = null, $isCallOnly = null, $isCallTrackingEnabled = null, $phoneNumber = null, $requireTollFreeTrackingNumber = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setIsCallOnly($isCallOnly)
            ->setIsCallTrackingEnabled($isCallTrackingEnabled)
            ->setPhoneNumber($phoneNumber)
            ->setRequireTollFreeTrackingNumber($requireTollFreeTrackingNumber);
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\CallAdExtension
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get IsCallOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCallOnly()
    {
        return isset($this->IsCallOnly) ? $this->IsCallOnly : null;
    }
    /**
     * Set IsCallOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCallOnly
     * @return \StructType\CallAdExtension
     */
    public function setIsCallOnly($isCallOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCallOnly) && !is_bool($isCallOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCallOnly, true), gettype($isCallOnly)), __LINE__);
        }
        if (is_null($isCallOnly) || (is_array($isCallOnly) && empty($isCallOnly))) {
            unset($this->IsCallOnly);
        } else {
            $this->IsCallOnly = $isCallOnly;
        }
        return $this;
    }
    /**
     * Get IsCallTrackingEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCallTrackingEnabled()
    {
        return isset($this->IsCallTrackingEnabled) ? $this->IsCallTrackingEnabled : null;
    }
    /**
     * Set IsCallTrackingEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCallTrackingEnabled
     * @return \StructType\CallAdExtension
     */
    public function setIsCallTrackingEnabled($isCallTrackingEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCallTrackingEnabled) && !is_bool($isCallTrackingEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCallTrackingEnabled, true), gettype($isCallTrackingEnabled)), __LINE__);
        }
        if (is_null($isCallTrackingEnabled) || (is_array($isCallTrackingEnabled) && empty($isCallTrackingEnabled))) {
            unset($this->IsCallTrackingEnabled);
        } else {
            $this->IsCallTrackingEnabled = $isCallTrackingEnabled;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\CallAdExtension
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get RequireTollFreeTrackingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequireTollFreeTrackingNumber()
    {
        return isset($this->RequireTollFreeTrackingNumber) ? $this->RequireTollFreeTrackingNumber : null;
    }
    /**
     * Set RequireTollFreeTrackingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requireTollFreeTrackingNumber
     * @return \StructType\CallAdExtension
     */
    public function setRequireTollFreeTrackingNumber($requireTollFreeTrackingNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($requireTollFreeTrackingNumber) && !is_bool($requireTollFreeTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requireTollFreeTrackingNumber, true), gettype($requireTollFreeTrackingNumber)), __LINE__);
        }
        if (is_null($requireTollFreeTrackingNumber) || (is_array($requireTollFreeTrackingNumber) && empty($requireTollFreeTrackingNumber))) {
            unset($this->RequireTollFreeTrackingNumber);
        } else {
            $this->RequireTollFreeTrackingNumber = $requireTollFreeTrackingNumber;
        }
        return $this;
    }
}
