<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AudienceCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AudienceCriterion
 * @subpackage Structs
 */
class AudienceCriterion extends Criterion
{
    /**
     * The AudienceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AudienceId;
    /**
     * The AudienceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AudienceType;
    /**
     * Constructor method for AudienceCriterion
     * @uses AudienceCriterion::setAudienceId()
     * @uses AudienceCriterion::setAudienceType()
     * @param int $audienceId
     * @param string[] $audienceType
     */
    public function __construct($audienceId = null, array $audienceType = array())
    {
        $this
            ->setAudienceId($audienceId)
            ->setAudienceType($audienceType);
    }
    /**
     * Get AudienceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAudienceId()
    {
        return isset($this->AudienceId) ? $this->AudienceId : null;
    }
    /**
     * Set AudienceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $audienceId
     * @return \StructType\AudienceCriterion
     */
    public function setAudienceId($audienceId = null)
    {
        // validation for constraint: int
        if (!is_null($audienceId) && !(is_int($audienceId) || ctype_digit($audienceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($audienceId, true), gettype($audienceId)), __LINE__);
        }
        if (is_null($audienceId) || (is_array($audienceId) && empty($audienceId))) {
            unset($this->AudienceId);
        } else {
            $this->AudienceId = $audienceId;
        }
        return $this;
    }
    /**
     * Get AudienceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAudienceType()
    {
        return isset($this->AudienceType) ? $this->AudienceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAudienceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAudienceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAudienceTypeForArrayConstraintsFromSetAudienceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $audienceCriterionAudienceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AudienceType::valueIsValid($audienceCriterionAudienceTypeItem)) {
                $invalidValues[] = is_object($audienceCriterionAudienceTypeItem) ? get_class($audienceCriterionAudienceTypeItem) : sprintf('%s(%s)', gettype($audienceCriterionAudienceTypeItem), var_export($audienceCriterionAudienceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AudienceType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AudienceType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AudienceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AudienceType::valueIsValid()
     * @uses \EnumType\AudienceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $audienceType
     * @return \StructType\AudienceCriterion
     */
    public function setAudienceType(array $audienceType = array())
    {
        // validation for constraint: list
        if ('' !== ($audienceTypeArrayErrorMessage = self::validateAudienceTypeForArrayConstraintsFromSetAudienceType($audienceType))) {
            throw new \InvalidArgumentException($audienceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($audienceType) || (is_array($audienceType) && empty($audienceType))) {
            unset($this->AudienceType);
        } else {
            $this->AudienceType = is_array($audienceType) ? implode(' ', $audienceType) : null;
        }
        return $this;
    }
}
