<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Audience StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Audience
 * @subpackage Structs
 */
class Audience extends AbstractStructBase
{
    /**
     * The AudienceNetworkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AudienceNetworkSize;
    /**
     * The CustomerShare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerShare
     */
    public $CustomerShare;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The MembershipDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MembershipDuration;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentId;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scope;
    /**
     * The SearchSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SearchSize;
    /**
     * The SupportedCampaignTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SupportedCampaignTypes;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Type;
    /**
     * Constructor method for Audience
     * @uses Audience::setAudienceNetworkSize()
     * @uses Audience::setCustomerShare()
     * @uses Audience::setDescription()
     * @uses Audience::setForwardCompatibilityMap()
     * @uses Audience::setId()
     * @uses Audience::setMembershipDuration()
     * @uses Audience::setName()
     * @uses Audience::setParentId()
     * @uses Audience::setScope()
     * @uses Audience::setSearchSize()
     * @uses Audience::setSupportedCampaignTypes()
     * @uses Audience::setType()
     * @param int $audienceNetworkSize
     * @param \StructType\CustomerShare $customerShare
     * @param string $description
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param int $membershipDuration
     * @param string $name
     * @param int $parentId
     * @param string $scope
     * @param int $searchSize
     * @param \ArrayType\ArrayOfstring $supportedCampaignTypes
     * @param string[] $type
     */
    public function __construct($audienceNetworkSize = null, \StructType\CustomerShare $customerShare = null, $description = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, $membershipDuration = null, $name = null, $parentId = null, $scope = null, $searchSize = null, \ArrayType\ArrayOfstring $supportedCampaignTypes = null, array $type = array())
    {
        $this
            ->setAudienceNetworkSize($audienceNetworkSize)
            ->setCustomerShare($customerShare)
            ->setDescription($description)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setMembershipDuration($membershipDuration)
            ->setName($name)
            ->setParentId($parentId)
            ->setScope($scope)
            ->setSearchSize($searchSize)
            ->setSupportedCampaignTypes($supportedCampaignTypes)
            ->setType($type);
    }
    /**
     * Get AudienceNetworkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAudienceNetworkSize()
    {
        return isset($this->AudienceNetworkSize) ? $this->AudienceNetworkSize : null;
    }
    /**
     * Set AudienceNetworkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $audienceNetworkSize
     * @return \StructType\Audience
     */
    public function setAudienceNetworkSize($audienceNetworkSize = null)
    {
        // validation for constraint: int
        if (!is_null($audienceNetworkSize) && !(is_int($audienceNetworkSize) || ctype_digit($audienceNetworkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($audienceNetworkSize, true), gettype($audienceNetworkSize)), __LINE__);
        }
        if (is_null($audienceNetworkSize) || (is_array($audienceNetworkSize) && empty($audienceNetworkSize))) {
            unset($this->AudienceNetworkSize);
        } else {
            $this->AudienceNetworkSize = $audienceNetworkSize;
        }
        return $this;
    }
    /**
     * Get CustomerShare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerShare|null
     */
    public function getCustomerShare()
    {
        return isset($this->CustomerShare) ? $this->CustomerShare : null;
    }
    /**
     * Set CustomerShare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerShare $customerShare
     * @return \StructType\Audience
     */
    public function setCustomerShare(\StructType\CustomerShare $customerShare = null)
    {
        if (is_null($customerShare) || (is_array($customerShare) && empty($customerShare))) {
            unset($this->CustomerShare);
        } else {
            $this->CustomerShare = $customerShare;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Audience
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\Audience
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Audience
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MembershipDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMembershipDuration()
    {
        return isset($this->MembershipDuration) ? $this->MembershipDuration : null;
    }
    /**
     * Set MembershipDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $membershipDuration
     * @return \StructType\Audience
     */
    public function setMembershipDuration($membershipDuration = null)
    {
        // validation for constraint: int
        if (!is_null($membershipDuration) && !(is_int($membershipDuration) || ctype_digit($membershipDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($membershipDuration, true), gettype($membershipDuration)), __LINE__);
        }
        if (is_null($membershipDuration) || (is_array($membershipDuration) && empty($membershipDuration))) {
            unset($this->MembershipDuration);
        } else {
            $this->MembershipDuration = $membershipDuration;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Audience
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentId
     * @return \StructType\Audience
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !(is_int($parentId) || ctype_digit($parentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get Scope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScope()
    {
        return isset($this->Scope) ? $this->Scope : null;
    }
    /**
     * Set Scope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scope
     * @return \StructType\Audience
     */
    public function setScope($scope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($scope) ? implode(', ', $scope) : var_export($scope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($scope) || (is_array($scope) && empty($scope))) {
            unset($this->Scope);
        } else {
            $this->Scope = $scope;
        }
        return $this;
    }
    /**
     * Get SearchSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSearchSize()
    {
        return isset($this->SearchSize) ? $this->SearchSize : null;
    }
    /**
     * Set SearchSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $searchSize
     * @return \StructType\Audience
     */
    public function setSearchSize($searchSize = null)
    {
        // validation for constraint: int
        if (!is_null($searchSize) && !(is_int($searchSize) || ctype_digit($searchSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchSize, true), gettype($searchSize)), __LINE__);
        }
        if (is_null($searchSize) || (is_array($searchSize) && empty($searchSize))) {
            unset($this->SearchSize);
        } else {
            $this->SearchSize = $searchSize;
        }
        return $this;
    }
    /**
     * Get SupportedCampaignTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSupportedCampaignTypes()
    {
        return isset($this->SupportedCampaignTypes) ? $this->SupportedCampaignTypes : null;
    }
    /**
     * Set SupportedCampaignTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $supportedCampaignTypes
     * @return \StructType\Audience
     */
    public function setSupportedCampaignTypes(\ArrayType\ArrayOfstring $supportedCampaignTypes = null)
    {
        if (is_null($supportedCampaignTypes) || (is_array($supportedCampaignTypes) && empty($supportedCampaignTypes))) {
            unset($this->SupportedCampaignTypes);
        } else {
            $this->SupportedCampaignTypes = $supportedCampaignTypes;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string[]|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $audienceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AudienceType::valueIsValid($audienceTypeItem)) {
                $invalidValues[] = is_object($audienceTypeItem) ? get_class($audienceTypeItem) : sprintf('%s(%s)', gettype($audienceTypeItem), var_export($audienceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AudienceType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AudienceType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * @uses \EnumType\AudienceType::valueIsValid()
     * @uses \EnumType\AudienceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \StructType\Audience
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        $this->Type = is_array($type) ? implode(' ', $type) : null;
        return $this;
    }
}
