<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetLink StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssetLink
 * @subpackage Structs
 */
class AssetLink extends AbstractStructBase
{
    /**
     * The Asset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Asset
     */
    public $Asset;
    /**
     * The AssetPerformanceLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssetPerformanceLabel;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditorialStatus;
    /**
     * The PinnedField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PinnedField;
    /**
     * Constructor method for AssetLink
     * @uses AssetLink::setAsset()
     * @uses AssetLink::setAssetPerformanceLabel()
     * @uses AssetLink::setEditorialStatus()
     * @uses AssetLink::setPinnedField()
     * @param \StructType\Asset $asset
     * @param string $assetPerformanceLabel
     * @param string $editorialStatus
     * @param string $pinnedField
     */
    public function __construct(\StructType\Asset $asset = null, $assetPerformanceLabel = null, $editorialStatus = null, $pinnedField = null)
    {
        $this
            ->setAsset($asset)
            ->setAssetPerformanceLabel($assetPerformanceLabel)
            ->setEditorialStatus($editorialStatus)
            ->setPinnedField($pinnedField);
    }
    /**
     * Get Asset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Asset|null
     */
    public function getAsset()
    {
        return isset($this->Asset) ? $this->Asset : null;
    }
    /**
     * Set Asset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Asset $asset
     * @return \StructType\AssetLink
     */
    public function setAsset(\StructType\Asset $asset = null)
    {
        if (is_null($asset) || (is_array($asset) && empty($asset))) {
            unset($this->Asset);
        } else {
            $this->Asset = $asset;
        }
        return $this;
    }
    /**
     * Get AssetPerformanceLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssetPerformanceLabel()
    {
        return isset($this->AssetPerformanceLabel) ? $this->AssetPerformanceLabel : null;
    }
    /**
     * Set AssetPerformanceLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assetPerformanceLabel
     * @return \StructType\AssetLink
     */
    public function setAssetPerformanceLabel($assetPerformanceLabel = null)
    {
        // validation for constraint: string
        if (!is_null($assetPerformanceLabel) && !is_string($assetPerformanceLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetPerformanceLabel, true), gettype($assetPerformanceLabel)), __LINE__);
        }
        if (is_null($assetPerformanceLabel) || (is_array($assetPerformanceLabel) && empty($assetPerformanceLabel))) {
            unset($this->AssetPerformanceLabel);
        } else {
            $this->AssetPerformanceLabel = $assetPerformanceLabel;
        }
        return $this;
    }
    /**
     * Get EditorialStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return isset($this->EditorialStatus) ? $this->EditorialStatus : null;
    }
    /**
     * Set EditorialStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AssetLinkEditorialStatus::valueIsValid()
     * @uses \EnumType\AssetLinkEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\AssetLink
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AssetLinkEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AssetLinkEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\AssetLinkEditorialStatus::getValidValues())), __LINE__);
        }
        if (is_null($editorialStatus) || (is_array($editorialStatus) && empty($editorialStatus))) {
            unset($this->EditorialStatus);
        } else {
            $this->EditorialStatus = $editorialStatus;
        }
        return $this;
    }
    /**
     * Get PinnedField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPinnedField()
    {
        return isset($this->PinnedField) ? $this->PinnedField : null;
    }
    /**
     * Set PinnedField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pinnedField
     * @return \StructType\AssetLink
     */
    public function setPinnedField($pinnedField = null)
    {
        // validation for constraint: string
        if (!is_null($pinnedField) && !is_string($pinnedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinnedField, true), gettype($pinnedField)), __LINE__);
        }
        if (is_null($pinnedField) || (is_array($pinnedField) && empty($pinnedField))) {
            unset($this->PinnedField);
        } else {
            $this->PinnedField = $pinnedField;
        }
        return $this;
    }
}
