<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyProductPartitionActionsResponse StructType
 * @subpackage Structs
 */
class ApplyProductPartitionActionsResponse extends AbstractStructBase
{
    /**
     * The AdGroupCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $AdGroupCriterionIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for ApplyProductPartitionActionsResponse
     * @uses ApplyProductPartitionActionsResponse::setAdGroupCriterionIds()
     * @uses ApplyProductPartitionActionsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $adGroupCriterionIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $adGroupCriterionIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdGroupCriterionIds($adGroupCriterionIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdGroupCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getAdGroupCriterionIds()
    {
        return isset($this->AdGroupCriterionIds) ? $this->AdGroupCriterionIds : null;
    }
    /**
     * Set AdGroupCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $adGroupCriterionIds
     * @return \StructType\ApplyProductPartitionActionsResponse
     */
    public function setAdGroupCriterionIds(\ArrayType\ArrayOfNullableOflong $adGroupCriterionIds = null)
    {
        if (is_null($adGroupCriterionIds) || (is_array($adGroupCriterionIds) && empty($adGroupCriterionIds))) {
            unset($this->AdGroupCriterionIds);
        } else {
            $this->AdGroupCriterionIds = $adGroupCriterionIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\ApplyProductPartitionActionsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
