<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppealEditorialRejectionsRequest StructType
 * @subpackage Structs
 */
class AppealEditorialRejectionsRequest extends AbstractStructBase
{
    /**
     * The EntityIdToParentIdAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEntityIdToParentIdAssociation
     */
    public $EntityIdToParentIdAssociations;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityType;
    /**
     * The JustificationText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JustificationText;
    /**
     * Constructor method for AppealEditorialRejectionsRequest
     * @uses AppealEditorialRejectionsRequest::setEntityIdToParentIdAssociations()
     * @uses AppealEditorialRejectionsRequest::setEntityType()
     * @uses AppealEditorialRejectionsRequest::setJustificationText()
     * @param \ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations
     * @param string $entityType
     * @param string $justificationText
     */
    public function __construct(\ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations = null, $entityType = null, $justificationText = null)
    {
        $this
            ->setEntityIdToParentIdAssociations($entityIdToParentIdAssociations)
            ->setEntityType($entityType)
            ->setJustificationText($justificationText);
    }
    /**
     * Get EntityIdToParentIdAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEntityIdToParentIdAssociation|null
     */
    public function getEntityIdToParentIdAssociations()
    {
        return isset($this->EntityIdToParentIdAssociations) ? $this->EntityIdToParentIdAssociations : null;
    }
    /**
     * Set EntityIdToParentIdAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations
     * @return \StructType\AppealEditorialRejectionsRequest
     */
    public function setEntityIdToParentIdAssociations(\ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations = null)
    {
        if (is_null($entityIdToParentIdAssociations) || (is_array($entityIdToParentIdAssociations) && empty($entityIdToParentIdAssociations))) {
            unset($this->EntityIdToParentIdAssociations);
        } else {
            $this->EntityIdToParentIdAssociations = $entityIdToParentIdAssociations;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\AppealEditorialRejectionsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get JustificationText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJustificationText()
    {
        return isset($this->JustificationText) ? $this->JustificationText : null;
    }
    /**
     * Set JustificationText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $justificationText
     * @return \StructType\AppealEditorialRejectionsRequest
     */
    public function setJustificationText($justificationText = null)
    {
        // validation for constraint: string
        if (!is_null($justificationText) && !is_string($justificationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justificationText, true), gettype($justificationText)), __LINE__);
        }
        if (is_null($justificationText) || (is_array($justificationText) && empty($justificationText))) {
            unset($this->JustificationText);
        } else {
            $this->JustificationText = $justificationText;
        }
        return $this;
    }
}
