<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddSharedEntityResponse StructType
 * @subpackage Structs
 */
class AddSharedEntityResponse extends AbstractStructBase
{
    /**
     * The ListItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ListItemIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * The SharedEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SharedEntityId;
    /**
     * Constructor method for AddSharedEntityResponse
     * @uses AddSharedEntityResponse::setListItemIds()
     * @uses AddSharedEntityResponse::setPartialErrors()
     * @uses AddSharedEntityResponse::setSharedEntityId()
     * @param \ArrayType\ArrayOflong $listItemIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @param int $sharedEntityId
     */
    public function __construct(\ArrayType\ArrayOflong $listItemIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null, $sharedEntityId = null)
    {
        $this
            ->setListItemIds($listItemIds)
            ->setPartialErrors($partialErrors)
            ->setSharedEntityId($sharedEntityId);
    }
    /**
     * Get ListItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getListItemIds()
    {
        return isset($this->ListItemIds) ? $this->ListItemIds : null;
    }
    /**
     * Set ListItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $listItemIds
     * @return \StructType\AddSharedEntityResponse
     */
    public function setListItemIds(\ArrayType\ArrayOflong $listItemIds = null)
    {
        if (is_null($listItemIds) || (is_array($listItemIds) && empty($listItemIds))) {
            unset($this->ListItemIds);
        } else {
            $this->ListItemIds = $listItemIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddSharedEntityResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
    /**
     * Get SharedEntityId value
     * @return int|null
     */
    public function getSharedEntityId()
    {
        return $this->SharedEntityId;
    }
    /**
     * Set SharedEntityId value
     * @param int $sharedEntityId
     * @return \StructType\AddSharedEntityResponse
     */
    public function setSharedEntityId($sharedEntityId = null)
    {
        // validation for constraint: int
        if (!is_null($sharedEntityId) && !(is_int($sharedEntityId) || ctype_digit($sharedEntityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sharedEntityId, true), gettype($sharedEntityId)), __LINE__);
        }
        $this->SharedEntityId = $sharedEntityId;
        return $this;
    }
}
