<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMediaRequest StructType
 * @subpackage Structs
 */
class AddMediaRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMedia
     */
    public $Media;
    /**
     * Constructor method for AddMediaRequest
     * @uses AddMediaRequest::setAccountId()
     * @uses AddMediaRequest::setMedia()
     * @param int $accountId
     * @param \ArrayType\ArrayOfMedia $media
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfMedia $media = null)
    {
        $this
            ->setAccountId($accountId)
            ->setMedia($media);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\AddMediaRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMedia|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMedia $media
     * @return \StructType\AddMediaRequest
     */
    public function setMedia(\ArrayType\ArrayOfMedia $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
}
