<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddListItemsToSharedListResponse StructType
 * @subpackage Structs
 */
class AddListItemsToSharedListResponse extends AbstractStructBase
{
    /**
     * The ListItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ListItemIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddListItemsToSharedListResponse
     * @uses AddListItemsToSharedListResponse::setListItemIds()
     * @uses AddListItemsToSharedListResponse::setPartialErrors()
     * @param \ArrayType\ArrayOflong $listItemIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOflong $listItemIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setListItemIds($listItemIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ListItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getListItemIds()
    {
        return isset($this->ListItemIds) ? $this->ListItemIds : null;
    }
    /**
     * Set ListItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $listItemIds
     * @return \StructType\AddListItemsToSharedListResponse
     */
    public function setListItemIds(\ArrayType\ArrayOflong $listItemIds = null)
    {
        if (is_null($listItemIds) || (is_array($listItemIds) && empty($listItemIds))) {
            unset($this->ListItemIds);
        } else {
            $this->ListItemIds = $listItemIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddListItemsToSharedListResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
