<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddListItemsToSharedListRequest StructType
 * @subpackage Structs
 */
class AddListItemsToSharedListRequest extends AbstractStructBase
{
    /**
     * The ListItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSharedListItem
     */
    public $ListItems;
    /**
     * The SharedList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SharedList
     */
    public $SharedList;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for AddListItemsToSharedListRequest
     * @uses AddListItemsToSharedListRequest::setListItems()
     * @uses AddListItemsToSharedListRequest::setSharedList()
     * @uses AddListItemsToSharedListRequest::setSharedEntityScope()
     * @param \ArrayType\ArrayOfSharedListItem $listItems
     * @param \StructType\SharedList $sharedList
     * @param string $sharedEntityScope
     */
    public function __construct(\ArrayType\ArrayOfSharedListItem $listItems = null, \StructType\SharedList $sharedList = null, $sharedEntityScope = null)
    {
        $this
            ->setListItems($listItems)
            ->setSharedList($sharedList)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get ListItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSharedListItem|null
     */
    public function getListItems()
    {
        return isset($this->ListItems) ? $this->ListItems : null;
    }
    /**
     * Set ListItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSharedListItem $listItems
     * @return \StructType\AddListItemsToSharedListRequest
     */
    public function setListItems(\ArrayType\ArrayOfSharedListItem $listItems = null)
    {
        if (is_null($listItems) || (is_array($listItems) && empty($listItems))) {
            unset($this->ListItems);
        } else {
            $this->ListItems = $listItems;
        }
        return $this;
    }
    /**
     * Get SharedList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SharedList|null
     */
    public function getSharedList()
    {
        return isset($this->SharedList) ? $this->SharedList : null;
    }
    /**
     * Set SharedList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SharedList $sharedList
     * @return \StructType\AddListItemsToSharedListRequest
     */
    public function setSharedList(\StructType\SharedList $sharedList = null)
    {
        if (is_null($sharedList) || (is_array($sharedList) && empty($sharedList))) {
            unset($this->SharedList);
        } else {
            $this->SharedList = $sharedList;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\AddListItemsToSharedListRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
