<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddLabelsResponse StructType
 * @subpackage Structs
 */
class AddLabelsResponse extends AbstractStructBase
{
    /**
     * The LabelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $LabelIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddLabelsResponse
     * @uses AddLabelsResponse::setLabelIds()
     * @uses AddLabelsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $labelIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $labelIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setLabelIds($labelIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get LabelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getLabelIds()
    {
        return isset($this->LabelIds) ? $this->LabelIds : null;
    }
    /**
     * Set LabelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $labelIds
     * @return \StructType\AddLabelsResponse
     */
    public function setLabelIds(\ArrayType\ArrayOfNullableOflong $labelIds = null)
    {
        if (is_null($labelIds) || (is_array($labelIds) && empty($labelIds))) {
            unset($this->LabelIds);
        } else {
            $this->LabelIds = $labelIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddLabelsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
