<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddLabelsRequest StructType
 * @subpackage Structs
 */
class AddLabelsRequest extends AbstractStructBase
{
    /**
     * The Labels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLabel
     */
    public $Labels;
    /**
     * Constructor method for AddLabelsRequest
     * @uses AddLabelsRequest::setLabels()
     * @param \ArrayType\ArrayOfLabel $labels
     */
    public function __construct(\ArrayType\ArrayOfLabel $labels = null)
    {
        $this
            ->setLabels($labels);
    }
    /**
     * Get Labels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return isset($this->Labels) ? $this->Labels : null;
    }
    /**
     * Set Labels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLabel $labels
     * @return \StructType\AddLabelsRequest
     */
    public function setLabels(\ArrayType\ArrayOfLabel $labels = null)
    {
        if (is_null($labels) || (is_array($labels) && empty($labels))) {
            unset($this->Labels);
        } else {
            $this->Labels = $labels;
        }
        return $this;
    }
}
