<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddKeywordsRequest StructType
 * @subpackage Structs
 */
class AddKeywordsRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The Keywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyword
     */
    public $Keywords;
    /**
     * The ReturnInheritedBidStrategyTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnInheritedBidStrategyTypes;
    /**
     * Constructor method for AddKeywordsRequest
     * @uses AddKeywordsRequest::setAdGroupId()
     * @uses AddKeywordsRequest::setKeywords()
     * @uses AddKeywordsRequest::setReturnInheritedBidStrategyTypes()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOfKeyword $keywords
     * @param bool $returnInheritedBidStrategyTypes
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOfKeyword $keywords = null, $returnInheritedBidStrategyTypes = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setKeywords($keywords)
            ->setReturnInheritedBidStrategyTypes($returnInheritedBidStrategyTypes);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\AddKeywordsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get Keywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyword|null
     */
    public function getKeywords()
    {
        return isset($this->Keywords) ? $this->Keywords : null;
    }
    /**
     * Set Keywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyword $keywords
     * @return \StructType\AddKeywordsRequest
     */
    public function setKeywords(\ArrayType\ArrayOfKeyword $keywords = null)
    {
        if (is_null($keywords) || (is_array($keywords) && empty($keywords))) {
            unset($this->Keywords);
        } else {
            $this->Keywords = $keywords;
        }
        return $this;
    }
    /**
     * Get ReturnInheritedBidStrategyTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnInheritedBidStrategyTypes()
    {
        return isset($this->ReturnInheritedBidStrategyTypes) ? $this->ReturnInheritedBidStrategyTypes : null;
    }
    /**
     * Set ReturnInheritedBidStrategyTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnInheritedBidStrategyTypes
     * @return \StructType\AddKeywordsRequest
     */
    public function setReturnInheritedBidStrategyTypes($returnInheritedBidStrategyTypes = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnInheritedBidStrategyTypes) && !is_bool($returnInheritedBidStrategyTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnInheritedBidStrategyTypes, true), gettype($returnInheritedBidStrategyTypes)), __LINE__);
        }
        if (is_null($returnInheritedBidStrategyTypes) || (is_array($returnInheritedBidStrategyTypes) && empty($returnInheritedBidStrategyTypes))) {
            unset($this->ReturnInheritedBidStrategyTypes);
        } else {
            $this->ReturnInheritedBidStrategyTypes = $returnInheritedBidStrategyTypes;
        }
        return $this;
    }
}
