<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCampaignCriterionsRequest StructType
 * @subpackage Structs
 */
class AddCampaignCriterionsRequest extends AbstractStructBase
{
    /**
     * The CampaignCriterions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaignCriterion
     */
    public $CampaignCriterions;
    /**
     * The CriterionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CriterionType;
    /**
     * Constructor method for AddCampaignCriterionsRequest
     * @uses AddCampaignCriterionsRequest::setCampaignCriterions()
     * @uses AddCampaignCriterionsRequest::setCriterionType()
     * @param \ArrayType\ArrayOfCampaignCriterion $campaignCriterions
     * @param string[] $criterionType
     */
    public function __construct(\ArrayType\ArrayOfCampaignCriterion $campaignCriterions = null, array $criterionType = array())
    {
        $this
            ->setCampaignCriterions($campaignCriterions)
            ->setCriterionType($criterionType);
    }
    /**
     * Get CampaignCriterions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaignCriterion|null
     */
    public function getCampaignCriterions()
    {
        return isset($this->CampaignCriterions) ? $this->CampaignCriterions : null;
    }
    /**
     * Set CampaignCriterions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaignCriterion $campaignCriterions
     * @return \StructType\AddCampaignCriterionsRequest
     */
    public function setCampaignCriterions(\ArrayType\ArrayOfCampaignCriterion $campaignCriterions = null)
    {
        if (is_null($campaignCriterions) || (is_array($campaignCriterions) && empty($campaignCriterions))) {
            unset($this->CampaignCriterions);
        } else {
            $this->CampaignCriterions = $campaignCriterions;
        }
        return $this;
    }
    /**
     * Get CriterionType value
     * @return string[]|null
     */
    public function getCriterionType()
    {
        return $this->CriterionType;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionTypeForArrayConstraintsFromSetCriterionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addCampaignCriterionsRequestCriterionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignCriterionType::valueIsValid($addCampaignCriterionsRequestCriterionTypeItem)) {
                $invalidValues[] = is_object($addCampaignCriterionsRequestCriterionTypeItem) ? get_class($addCampaignCriterionsRequestCriterionTypeItem) : sprintf('%s(%s)', gettype($addCampaignCriterionsRequestCriterionTypeItem), var_export($addCampaignCriterionsRequestCriterionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignCriterionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignCriterionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CriterionType value
     * @uses \EnumType\CampaignCriterionType::valueIsValid()
     * @uses \EnumType\CampaignCriterionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $criterionType
     * @return \StructType\AddCampaignCriterionsRequest
     */
    public function setCriterionType(array $criterionType = array())
    {
        // validation for constraint: list
        if ('' !== ($criterionTypeArrayErrorMessage = self::validateCriterionTypeForArrayConstraintsFromSetCriterionType($criterionType))) {
            throw new \InvalidArgumentException($criterionTypeArrayErrorMessage, __LINE__);
        }
        $this->CriterionType = is_array($criterionType) ? implode(' ', $criterionType) : null;
        return $this;
    }
}
