<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBudgetsResponse StructType
 * @subpackage Structs
 */
class AddBudgetsResponse extends AbstractStructBase
{
    /**
     * The BudgetIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $BudgetIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddBudgetsResponse
     * @uses AddBudgetsResponse::setBudgetIds()
     * @uses AddBudgetsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $budgetIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $budgetIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setBudgetIds($budgetIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get BudgetIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getBudgetIds()
    {
        return isset($this->BudgetIds) ? $this->BudgetIds : null;
    }
    /**
     * Set BudgetIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $budgetIds
     * @return \StructType\AddBudgetsResponse
     */
    public function setBudgetIds(\ArrayType\ArrayOfNullableOflong $budgetIds = null)
    {
        if (is_null($budgetIds) || (is_array($budgetIds) && empty($budgetIds))) {
            unset($this->BudgetIds);
        } else {
            $this->BudgetIds = $budgetIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddBudgetsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
