<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBudgetsRequest StructType
 * @subpackage Structs
 */
class AddBudgetsRequest extends AbstractStructBase
{
    /**
     * The Budgets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBudget
     */
    public $Budgets;
    /**
     * Constructor method for AddBudgetsRequest
     * @uses AddBudgetsRequest::setBudgets()
     * @param \ArrayType\ArrayOfBudget $budgets
     */
    public function __construct(\ArrayType\ArrayOfBudget $budgets = null)
    {
        $this
            ->setBudgets($budgets);
    }
    /**
     * Get Budgets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBudget|null
     */
    public function getBudgets()
    {
        return isset($this->Budgets) ? $this->Budgets : null;
    }
    /**
     * Set Budgets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBudget $budgets
     * @return \StructType\AddBudgetsRequest
     */
    public function setBudgets(\ArrayType\ArrayOfBudget $budgets = null)
    {
        if (is_null($budgets) || (is_array($budgets) && empty($budgets))) {
            unset($this->Budgets);
        } else {
            $this->Budgets = $budgets;
        }
        return $this;
    }
}
