<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdGroupCriterionsRequest StructType
 * @subpackage Structs
 */
class AddAdGroupCriterionsRequest extends AbstractStructBase
{
    /**
     * The AdGroupCriterions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroupCriterion
     */
    public $AdGroupCriterions;
    /**
     * The CriterionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CriterionType;
    /**
     * Constructor method for AddAdGroupCriterionsRequest
     * @uses AddAdGroupCriterionsRequest::setAdGroupCriterions()
     * @uses AddAdGroupCriterionsRequest::setCriterionType()
     * @param \ArrayType\ArrayOfAdGroupCriterion $adGroupCriterions
     * @param string[] $criterionType
     */
    public function __construct(\ArrayType\ArrayOfAdGroupCriterion $adGroupCriterions = null, array $criterionType = array())
    {
        $this
            ->setAdGroupCriterions($adGroupCriterions)
            ->setCriterionType($criterionType);
    }
    /**
     * Get AdGroupCriterions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroupCriterion|null
     */
    public function getAdGroupCriterions()
    {
        return isset($this->AdGroupCriterions) ? $this->AdGroupCriterions : null;
    }
    /**
     * Set AdGroupCriterions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroupCriterion $adGroupCriterions
     * @return \StructType\AddAdGroupCriterionsRequest
     */
    public function setAdGroupCriterions(\ArrayType\ArrayOfAdGroupCriterion $adGroupCriterions = null)
    {
        if (is_null($adGroupCriterions) || (is_array($adGroupCriterions) && empty($adGroupCriterions))) {
            unset($this->AdGroupCriterions);
        } else {
            $this->AdGroupCriterions = $adGroupCriterions;
        }
        return $this;
    }
    /**
     * Get CriterionType value
     * @return string[]|null
     */
    public function getCriterionType()
    {
        return $this->CriterionType;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionTypeForArrayConstraintsFromSetCriterionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addAdGroupCriterionsRequestCriterionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupCriterionType::valueIsValid($addAdGroupCriterionsRequestCriterionTypeItem)) {
                $invalidValues[] = is_object($addAdGroupCriterionsRequestCriterionTypeItem) ? get_class($addAdGroupCriterionsRequestCriterionTypeItem) : sprintf('%s(%s)', gettype($addAdGroupCriterionsRequestCriterionTypeItem), var_export($addAdGroupCriterionsRequestCriterionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupCriterionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupCriterionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CriterionType value
     * @uses \EnumType\AdGroupCriterionType::valueIsValid()
     * @uses \EnumType\AdGroupCriterionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $criterionType
     * @return \StructType\AddAdGroupCriterionsRequest
     */
    public function setCriterionType(array $criterionType = array())
    {
        // validation for constraint: list
        if ('' !== ($criterionTypeArrayErrorMessage = self::validateCriterionTypeForArrayConstraintsFromSetCriterionType($criterionType))) {
            throw new \InvalidArgumentException($criterionTypeArrayErrorMessage, __LINE__);
        }
        $this->CriterionType = is_array($criterionType) ? implode(' ', $criterionType) : null;
        return $this;
    }
}
