<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdExtensionsResponse StructType
 * @subpackage Structs
 */
class AddAdExtensionsResponse extends AbstractStructBase
{
    /**
     * The AdExtensionIdentities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdExtensionIdentity
     */
    public $AdExtensionIdentities;
    /**
     * The NestedPartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchErrorCollection
     */
    public $NestedPartialErrors;
    /**
     * Constructor method for AddAdExtensionsResponse
     * @uses AddAdExtensionsResponse::setAdExtensionIdentities()
     * @uses AddAdExtensionsResponse::setNestedPartialErrors()
     * @param \ArrayType\ArrayOfAdExtensionIdentity $adExtensionIdentities
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     */
    public function __construct(\ArrayType\ArrayOfAdExtensionIdentity $adExtensionIdentities = null, \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        $this
            ->setAdExtensionIdentities($adExtensionIdentities)
            ->setNestedPartialErrors($nestedPartialErrors);
    }
    /**
     * Get AdExtensionIdentities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdExtensionIdentity|null
     */
    public function getAdExtensionIdentities()
    {
        return isset($this->AdExtensionIdentities) ? $this->AdExtensionIdentities : null;
    }
    /**
     * Set AdExtensionIdentities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdExtensionIdentity $adExtensionIdentities
     * @return \StructType\AddAdExtensionsResponse
     */
    public function setAdExtensionIdentities(\ArrayType\ArrayOfAdExtensionIdentity $adExtensionIdentities = null)
    {
        if (is_null($adExtensionIdentities) || (is_array($adExtensionIdentities) && empty($adExtensionIdentities))) {
            unset($this->AdExtensionIdentities);
        } else {
            $this->AdExtensionIdentities = $adExtensionIdentities;
        }
        return $this;
    }
    /**
     * Get NestedPartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchErrorCollection|null
     */
    public function getNestedPartialErrors()
    {
        return isset($this->NestedPartialErrors) ? $this->NestedPartialErrors : null;
    }
    /**
     * Set NestedPartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     * @return \StructType\AddAdExtensionsResponse
     */
    public function setNestedPartialErrors(\ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        if (is_null($nestedPartialErrors) || (is_array($nestedPartialErrors) && empty($nestedPartialErrors))) {
            unset($this->NestedPartialErrors);
        } else {
            $this->NestedPartialErrors = $nestedPartialErrors;
        }
        return $this;
    }
}
