<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdGroupNegativeSites StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdGroupNegativeSites
 * @subpackage Structs
 */
class AdGroupNegativeSites extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The NegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $NegativeSites;
    /**
     * Constructor method for AdGroupNegativeSites
     * @uses AdGroupNegativeSites::setAdGroupId()
     * @uses AdGroupNegativeSites::setNegativeSites()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOfstring $negativeSites
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOfstring $negativeSites = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setNegativeSites($negativeSites);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\AdGroupNegativeSites
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get NegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getNegativeSites()
    {
        return isset($this->NegativeSites) ? $this->NegativeSites : null;
    }
    /**
     * Set NegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $negativeSites
     * @return \StructType\AdGroupNegativeSites
     */
    public function setNegativeSites(\ArrayType\ArrayOfstring $negativeSites = null)
    {
        if (is_null($negativeSites) || (is_array($negativeSites) && empty($negativeSites))) {
            unset($this->NegativeSites);
        } else {
            $this->NegativeSites = $negativeSites;
        }
        return $this;
    }
}
