<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdGroup
 * @subpackage Structs
 */
class AdGroup extends AbstractStructBase
{
    /**
     * The AdRotation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdRotation
     */
    public $AdRotation;
    /**
     * The AudienceAdsBidAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AudienceAdsBidAdjustment;
    /**
     * The BiddingScheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BiddingScheme
     */
    public $BiddingScheme;
    /**
     * The CpcBid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $CpcBid;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $EndDate;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The MultimediaAdsBidAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MultimediaAdsBidAdjustment;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Network
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Network;
    /**
     * The PrivacyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrivacyStatus;
    /**
     * The Settings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSetting
     */
    public $Settings;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * The AdScheduleUseSearcherTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AdScheduleUseSearcherTimeZone;
    /**
     * The AdGroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdGroupType;
    /**
     * The CpvBid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $CpvBid;
    /**
     * The CpmBid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $CpmBid;
    /**
     * Constructor method for AdGroup
     * @uses AdGroup::setAdRotation()
     * @uses AdGroup::setAudienceAdsBidAdjustment()
     * @uses AdGroup::setBiddingScheme()
     * @uses AdGroup::setCpcBid()
     * @uses AdGroup::setEndDate()
     * @uses AdGroup::setFinalUrlSuffix()
     * @uses AdGroup::setForwardCompatibilityMap()
     * @uses AdGroup::setId()
     * @uses AdGroup::setLanguage()
     * @uses AdGroup::setMultimediaAdsBidAdjustment()
     * @uses AdGroup::setName()
     * @uses AdGroup::setNetwork()
     * @uses AdGroup::setPrivacyStatus()
     * @uses AdGroup::setSettings()
     * @uses AdGroup::setStartDate()
     * @uses AdGroup::setStatus()
     * @uses AdGroup::setTrackingUrlTemplate()
     * @uses AdGroup::setUrlCustomParameters()
     * @uses AdGroup::setAdScheduleUseSearcherTimeZone()
     * @uses AdGroup::setAdGroupType()
     * @uses AdGroup::setCpvBid()
     * @uses AdGroup::setCpmBid()
     * @param \StructType\AdRotation $adRotation
     * @param int $audienceAdsBidAdjustment
     * @param \StructType\BiddingScheme $biddingScheme
     * @param \StructType\Bid $cpcBid
     * @param \StructType\Date $endDate
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param string $language
     * @param int $multimediaAdsBidAdjustment
     * @param string $name
     * @param string $network
     * @param string $privacyStatus
     * @param \ArrayType\ArrayOfSetting $settings
     * @param \StructType\Date $startDate
     * @param string $status
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     * @param bool $adScheduleUseSearcherTimeZone
     * @param string $adGroupType
     * @param \StructType\Bid $cpvBid
     * @param \StructType\Bid $cpmBid
     */
    public function __construct(\StructType\AdRotation $adRotation = null, $audienceAdsBidAdjustment = null, \StructType\BiddingScheme $biddingScheme = null, \StructType\Bid $cpcBid = null, \StructType\Date $endDate = null, $finalUrlSuffix = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, $language = null, $multimediaAdsBidAdjustment = null, $name = null, $network = null, $privacyStatus = null, \ArrayType\ArrayOfSetting $settings = null, \StructType\Date $startDate = null, $status = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null, $adScheduleUseSearcherTimeZone = null, $adGroupType = null, \StructType\Bid $cpvBid = null, \StructType\Bid $cpmBid = null)
    {
        $this
            ->setAdRotation($adRotation)
            ->setAudienceAdsBidAdjustment($audienceAdsBidAdjustment)
            ->setBiddingScheme($biddingScheme)
            ->setCpcBid($cpcBid)
            ->setEndDate($endDate)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setLanguage($language)
            ->setMultimediaAdsBidAdjustment($multimediaAdsBidAdjustment)
            ->setName($name)
            ->setNetwork($network)
            ->setPrivacyStatus($privacyStatus)
            ->setSettings($settings)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters)
            ->setAdScheduleUseSearcherTimeZone($adScheduleUseSearcherTimeZone)
            ->setAdGroupType($adGroupType)
            ->setCpvBid($cpvBid)
            ->setCpmBid($cpmBid);
    }
    /**
     * Get AdRotation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdRotation|null
     */
    public function getAdRotation()
    {
        return isset($this->AdRotation) ? $this->AdRotation : null;
    }
    /**
     * Set AdRotation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdRotation $adRotation
     * @return \StructType\AdGroup
     */
    public function setAdRotation(\StructType\AdRotation $adRotation = null)
    {
        if (is_null($adRotation) || (is_array($adRotation) && empty($adRotation))) {
            unset($this->AdRotation);
        } else {
            $this->AdRotation = $adRotation;
        }
        return $this;
    }
    /**
     * Get AudienceAdsBidAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAudienceAdsBidAdjustment()
    {
        return isset($this->AudienceAdsBidAdjustment) ? $this->AudienceAdsBidAdjustment : null;
    }
    /**
     * Set AudienceAdsBidAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $audienceAdsBidAdjustment
     * @return \StructType\AdGroup
     */
    public function setAudienceAdsBidAdjustment($audienceAdsBidAdjustment = null)
    {
        // validation for constraint: int
        if (!is_null($audienceAdsBidAdjustment) && !(is_int($audienceAdsBidAdjustment) || ctype_digit($audienceAdsBidAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($audienceAdsBidAdjustment, true), gettype($audienceAdsBidAdjustment)), __LINE__);
        }
        if (is_null($audienceAdsBidAdjustment) || (is_array($audienceAdsBidAdjustment) && empty($audienceAdsBidAdjustment))) {
            unset($this->AudienceAdsBidAdjustment);
        } else {
            $this->AudienceAdsBidAdjustment = $audienceAdsBidAdjustment;
        }
        return $this;
    }
    /**
     * Get BiddingScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BiddingScheme|null
     */
    public function getBiddingScheme()
    {
        return isset($this->BiddingScheme) ? $this->BiddingScheme : null;
    }
    /**
     * Set BiddingScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BiddingScheme $biddingScheme
     * @return \StructType\AdGroup
     */
    public function setBiddingScheme(\StructType\BiddingScheme $biddingScheme = null)
    {
        if (is_null($biddingScheme) || (is_array($biddingScheme) && empty($biddingScheme))) {
            unset($this->BiddingScheme);
        } else {
            $this->BiddingScheme = $biddingScheme;
        }
        return $this;
    }
    /**
     * Get CpcBid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getCpcBid()
    {
        return isset($this->CpcBid) ? $this->CpcBid : null;
    }
    /**
     * Set CpcBid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $cpcBid
     * @return \StructType\AdGroup
     */
    public function setCpcBid(\StructType\Bid $cpcBid = null)
    {
        if (is_null($cpcBid) || (is_array($cpcBid) && empty($cpcBid))) {
            unset($this->CpcBid);
        } else {
            $this->CpcBid = $cpcBid;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $endDate
     * @return \StructType\AdGroup
     */
    public function setEndDate(\StructType\Date $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\AdGroup
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\AdGroup
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\AdGroup
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\AdGroup
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get MultimediaAdsBidAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMultimediaAdsBidAdjustment()
    {
        return isset($this->MultimediaAdsBidAdjustment) ? $this->MultimediaAdsBidAdjustment : null;
    }
    /**
     * Set MultimediaAdsBidAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $multimediaAdsBidAdjustment
     * @return \StructType\AdGroup
     */
    public function setMultimediaAdsBidAdjustment($multimediaAdsBidAdjustment = null)
    {
        // validation for constraint: int
        if (!is_null($multimediaAdsBidAdjustment) && !(is_int($multimediaAdsBidAdjustment) || ctype_digit($multimediaAdsBidAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($multimediaAdsBidAdjustment, true), gettype($multimediaAdsBidAdjustment)), __LINE__);
        }
        if (is_null($multimediaAdsBidAdjustment) || (is_array($multimediaAdsBidAdjustment) && empty($multimediaAdsBidAdjustment))) {
            unset($this->MultimediaAdsBidAdjustment);
        } else {
            $this->MultimediaAdsBidAdjustment = $multimediaAdsBidAdjustment;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AdGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Network value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetwork()
    {
        return isset($this->Network) ? $this->Network : null;
    }
    /**
     * Set Network value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Network::valueIsValid()
     * @uses \EnumType\Network::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $network
     * @return \StructType\AdGroup
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Network::valueIsValid($network)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Network', is_array($network) ? implode(', ', $network) : var_export($network, true), implode(', ', \EnumType\Network::getValidValues())), __LINE__);
        }
        if (is_null($network) || (is_array($network) && empty($network))) {
            unset($this->Network);
        } else {
            $this->Network = $network;
        }
        return $this;
    }
    /**
     * Get PrivacyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacyStatus()
    {
        return isset($this->PrivacyStatus) ? $this->PrivacyStatus : null;
    }
    /**
     * Set PrivacyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupPrivacyStatus::valueIsValid()
     * @uses \EnumType\AdGroupPrivacyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacyStatus
     * @return \StructType\AdGroup
     */
    public function setPrivacyStatus($privacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdGroupPrivacyStatus::valueIsValid($privacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupPrivacyStatus', is_array($privacyStatus) ? implode(', ', $privacyStatus) : var_export($privacyStatus, true), implode(', ', \EnumType\AdGroupPrivacyStatus::getValidValues())), __LINE__);
        }
        if (is_null($privacyStatus) || (is_array($privacyStatus) && empty($privacyStatus))) {
            unset($this->PrivacyStatus);
        } else {
            $this->PrivacyStatus = $privacyStatus;
        }
        return $this;
    }
    /**
     * Get Settings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSetting|null
     */
    public function getSettings()
    {
        return isset($this->Settings) ? $this->Settings : null;
    }
    /**
     * Set Settings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSetting $settings
     * @return \StructType\AdGroup
     */
    public function setSettings(\ArrayType\ArrayOfSetting $settings = null)
    {
        if (is_null($settings) || (is_array($settings) && empty($settings))) {
            unset($this->Settings);
        } else {
            $this->Settings = $settings;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $startDate
     * @return \StructType\AdGroup
     */
    public function setStartDate(\StructType\Date $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatus::valueIsValid()
     * @uses \EnumType\AdGroupStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AdGroup
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdGroupStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AdGroupStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\AdGroup
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\AdGroup
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
    /**
     * Get AdScheduleUseSearcherTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAdScheduleUseSearcherTimeZone()
    {
        return isset($this->AdScheduleUseSearcherTimeZone) ? $this->AdScheduleUseSearcherTimeZone : null;
    }
    /**
     * Set AdScheduleUseSearcherTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $adScheduleUseSearcherTimeZone
     * @return \StructType\AdGroup
     */
    public function setAdScheduleUseSearcherTimeZone($adScheduleUseSearcherTimeZone = null)
    {
        // validation for constraint: boolean
        if (!is_null($adScheduleUseSearcherTimeZone) && !is_bool($adScheduleUseSearcherTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($adScheduleUseSearcherTimeZone, true), gettype($adScheduleUseSearcherTimeZone)), __LINE__);
        }
        if (is_null($adScheduleUseSearcherTimeZone) || (is_array($adScheduleUseSearcherTimeZone) && empty($adScheduleUseSearcherTimeZone))) {
            unset($this->AdScheduleUseSearcherTimeZone);
        } else {
            $this->AdScheduleUseSearcherTimeZone = $adScheduleUseSearcherTimeZone;
        }
        return $this;
    }
    /**
     * Get AdGroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdGroupType()
    {
        return isset($this->AdGroupType) ? $this->AdGroupType : null;
    }
    /**
     * Set AdGroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adGroupType
     * @return \StructType\AdGroup
     */
    public function setAdGroupType($adGroupType = null)
    {
        // validation for constraint: string
        if (!is_null($adGroupType) && !is_string($adGroupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adGroupType, true), gettype($adGroupType)), __LINE__);
        }
        if (is_null($adGroupType) || (is_array($adGroupType) && empty($adGroupType))) {
            unset($this->AdGroupType);
        } else {
            $this->AdGroupType = $adGroupType;
        }
        return $this;
    }
    /**
     * Get CpvBid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getCpvBid()
    {
        return isset($this->CpvBid) ? $this->CpvBid : null;
    }
    /**
     * Set CpvBid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $cpvBid
     * @return \StructType\AdGroup
     */
    public function setCpvBid(\StructType\Bid $cpvBid = null)
    {
        if (is_null($cpvBid) || (is_array($cpvBid) && empty($cpvBid))) {
            unset($this->CpvBid);
        } else {
            $this->CpvBid = $cpvBid;
        }
        return $this;
    }
    /**
     * Get CpmBid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getCpmBid()
    {
        return isset($this->CpmBid) ? $this->CpmBid : null;
    }
    /**
     * Set CpmBid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $cpmBid
     * @return \StructType\AdGroup
     */
    public function setCpmBid(\StructType\Bid $cpmBid = null)
    {
        if (is_null($cpmBid) || (is_array($cpmBid) && empty($cpmBid))) {
            unset($this->CpmBid);
        } else {
            $this->CpmBid = $cpmBid;
        }
        return $this;
    }
}
