<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ad StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ad
 * @subpackage Structs
 */
class Ad extends AbstractStructBase
{
    /**
     * The AdFormatPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdFormatPreference;
    /**
     * The DevicePreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DevicePreference;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditorialStatus;
    /**
     * The FinalAppUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAppUrl
     */
    public $FinalAppUrls;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * Constructor method for Ad
     * @uses Ad::setAdFormatPreference()
     * @uses Ad::setDevicePreference()
     * @uses Ad::setEditorialStatus()
     * @uses Ad::setFinalAppUrls()
     * @uses Ad::setFinalMobileUrls()
     * @uses Ad::setFinalUrlSuffix()
     * @uses Ad::setFinalUrls()
     * @uses Ad::setForwardCompatibilityMap()
     * @uses Ad::setId()
     * @uses Ad::setStatus()
     * @uses Ad::setTrackingUrlTemplate()
     * @uses Ad::setType()
     * @uses Ad::setUrlCustomParameters()
     * @param string $adFormatPreference
     * @param int $devicePreference
     * @param string $editorialStatus
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param string $status
     * @param string $trackingUrlTemplate
     * @param string $type
     * @param \StructType\CustomParameters $urlCustomParameters
     */
    public function __construct($adFormatPreference = null, $devicePreference = null, $editorialStatus = null, \ArrayType\ArrayOfAppUrl $finalAppUrls = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, $finalUrlSuffix = null, \ArrayType\ArrayOfstring $finalUrls = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, $status = null, $trackingUrlTemplate = null, $type = null, \StructType\CustomParameters $urlCustomParameters = null)
    {
        $this
            ->setAdFormatPreference($adFormatPreference)
            ->setDevicePreference($devicePreference)
            ->setEditorialStatus($editorialStatus)
            ->setFinalAppUrls($finalAppUrls)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setFinalUrls($finalUrls)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setStatus($status)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setType($type)
            ->setUrlCustomParameters($urlCustomParameters);
    }
    /**
     * Get AdFormatPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdFormatPreference()
    {
        return isset($this->AdFormatPreference) ? $this->AdFormatPreference : null;
    }
    /**
     * Set AdFormatPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adFormatPreference
     * @return \StructType\Ad
     */
    public function setAdFormatPreference($adFormatPreference = null)
    {
        // validation for constraint: string
        if (!is_null($adFormatPreference) && !is_string($adFormatPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adFormatPreference, true), gettype($adFormatPreference)), __LINE__);
        }
        if (is_null($adFormatPreference) || (is_array($adFormatPreference) && empty($adFormatPreference))) {
            unset($this->AdFormatPreference);
        } else {
            $this->AdFormatPreference = $adFormatPreference;
        }
        return $this;
    }
    /**
     * Get DevicePreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDevicePreference()
    {
        return isset($this->DevicePreference) ? $this->DevicePreference : null;
    }
    /**
     * Set DevicePreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $devicePreference
     * @return \StructType\Ad
     */
    public function setDevicePreference($devicePreference = null)
    {
        // validation for constraint: int
        if (!is_null($devicePreference) && !(is_int($devicePreference) || ctype_digit($devicePreference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($devicePreference, true), gettype($devicePreference)), __LINE__);
        }
        if (is_null($devicePreference) || (is_array($devicePreference) && empty($devicePreference))) {
            unset($this->DevicePreference);
        } else {
            $this->DevicePreference = $devicePreference;
        }
        return $this;
    }
    /**
     * Get EditorialStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return isset($this->EditorialStatus) ? $this->EditorialStatus : null;
    }
    /**
     * Set EditorialStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdEditorialStatus::valueIsValid()
     * @uses \EnumType\AdEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\Ad
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\AdEditorialStatus::getValidValues())), __LINE__);
        }
        if (is_null($editorialStatus) || (is_array($editorialStatus) && empty($editorialStatus))) {
            unset($this->EditorialStatus);
        } else {
            $this->EditorialStatus = $editorialStatus;
        }
        return $this;
    }
    /**
     * Get FinalAppUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAppUrl|null
     */
    public function getFinalAppUrls()
    {
        return isset($this->FinalAppUrls) ? $this->FinalAppUrls : null;
    }
    /**
     * Set FinalAppUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @return \StructType\Ad
     */
    public function setFinalAppUrls(\ArrayType\ArrayOfAppUrl $finalAppUrls = null)
    {
        if (is_null($finalAppUrls) || (is_array($finalAppUrls) && empty($finalAppUrls))) {
            unset($this->FinalAppUrls);
        } else {
            $this->FinalAppUrls = $finalAppUrls;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\Ad
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\Ad
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\Ad
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\Ad
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Ad
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdStatus::valueIsValid()
     * @uses \EnumType\AdStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Ad
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AdStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\Ad
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdType::valueIsValid()
     * @uses \EnumType\AdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Ad
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\AdType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\Ad
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
}
