<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountMigrationStatusesInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountMigrationStatusesInfo
 * @subpackage Structs
 */
class AccountMigrationStatusesInfo extends AbstractStructBase
{
    /**
     * The AccountId
     * @var int
     */
    public $AccountId;
    /**
     * The MigrationStatusInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMigrationStatusInfo
     */
    public $MigrationStatusInfos;
    /**
     * Constructor method for AccountMigrationStatusesInfo
     * @uses AccountMigrationStatusesInfo::setAccountId()
     * @uses AccountMigrationStatusesInfo::setMigrationStatusInfos()
     * @param int $accountId
     * @param \ArrayType\ArrayOfMigrationStatusInfo $migrationStatusInfos
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfMigrationStatusInfo $migrationStatusInfos = null)
    {
        $this
            ->setAccountId($accountId)
            ->setMigrationStatusInfos($migrationStatusInfos);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\AccountMigrationStatusesInfo
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get MigrationStatusInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMigrationStatusInfo|null
     */
    public function getMigrationStatusInfos()
    {
        return isset($this->MigrationStatusInfos) ? $this->MigrationStatusInfos : null;
    }
    /**
     * Set MigrationStatusInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMigrationStatusInfo $migrationStatusInfos
     * @return \StructType\AccountMigrationStatusesInfo
     */
    public function setMigrationStatusInfos(\ArrayType\ArrayOfMigrationStatusInfo $migrationStatusInfos = null)
    {
        if (is_null($migrationStatusInfos) || (is_array($migrationStatusInfos) && empty($migrationStatusInfos))) {
            unset($this->MigrationStatusInfos);
        } else {
            $this->MigrationStatusInfos = $migrationStatusInfos;
        }
        return $this;
    }
}
