<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $applicationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationToken($applicationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationToken', $applicationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthenticationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $authenticationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationToken($authenticationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationToken', $authenticationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerAccountId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerAccountId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerAccountId($customerAccountId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerAccountId', $customerAccountId, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerId($customerId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerId', $customerId, $mustUnderstand, $actor);
    }
    /**
     * Sets the DeveloperToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $developerToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDeveloperToken($developerToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DeveloperToken', $developerToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the Password SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $password
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassword($password, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Password', $password, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateCampaigns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCampaignsRequest $parameters
     * @return \StructType\UpdateCampaignsResponse|bool
     */
    public function UpdateCampaigns(\StructType\UpdateCampaignsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCampaigns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAdGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAdGroupsRequest $parameters
     * @return \StructType\UpdateAdGroupsResponse|bool
     */
    public function UpdateAdGroups(\StructType\UpdateAdGroupsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAdGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAdsRequest $parameters
     * @return \StructType\UpdateAdsResponse|bool
     */
    public function UpdateAds(\StructType\UpdateAdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateKeywords
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateKeywordsRequest $parameters
     * @return \StructType\UpdateKeywordsResponse|bool
     */
    public function UpdateKeywords(\StructType\UpdateKeywordsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateKeywords($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAdExtensions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAdExtensionsRequest $parameters
     * @return \StructType\UpdateAdExtensionsResponse|bool
     */
    public function UpdateAdExtensions(\StructType\UpdateAdExtensionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAdExtensions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAdGroupCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAdGroupCriterionsRequest $parameters
     * @return \StructType\UpdateAdGroupCriterionsResponse|bool
     */
    public function UpdateAdGroupCriterions(\StructType\UpdateAdGroupCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAdGroupCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSharedEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSharedEntitiesRequest $parameters
     * @return \StructType\UpdateSharedEntitiesResponse|bool
     */
    public function UpdateSharedEntities(\StructType\UpdateSharedEntitiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSharedEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCampaignCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCampaignCriterionsRequest $parameters
     * @return \StructType\UpdateCampaignCriterionsResponse|bool
     */
    public function UpdateCampaignCriterions(\StructType\UpdateCampaignCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCampaignCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateBudgets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateBudgetsRequest $parameters
     * @return \StructType\UpdateBudgetsResponse|bool
     */
    public function UpdateBudgets(\StructType\UpdateBudgetsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateBudgets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateBidStrategies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateBidStrategiesRequest $parameters
     * @return \StructType\UpdateBidStrategiesResponse|bool
     */
    public function UpdateBidStrategies(\StructType\UpdateBidStrategiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateBidStrategies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAudiences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAudiencesRequest $parameters
     * @return \StructType\UpdateAudiencesResponse|bool
     */
    public function UpdateAudiences(\StructType\UpdateAudiencesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAudiences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUetTags
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUetTagsRequest $parameters
     * @return \StructType\UpdateUetTagsResponse|bool
     */
    public function UpdateUetTags(\StructType\UpdateUetTagsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUetTags($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateConversionGoals
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateConversionGoalsRequest $parameters
     * @return \StructType\UpdateConversionGoalsResponse|bool
     */
    public function UpdateConversionGoals(\StructType\UpdateConversionGoalsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateConversionGoals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLabels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLabelsRequest $parameters
     * @return \StructType\UpdateLabelsResponse|bool
     */
    public function UpdateLabels(\StructType\UpdateLabelsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateExperiments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateExperimentsRequest $parameters
     * @return \StructType\UpdateExperimentsResponse|bool
     */
    public function UpdateExperiments(\StructType\UpdateExperimentsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExperiments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateImportJobs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImportJobsRequest $parameters
     * @return \StructType\UpdateImportJobsResponse|bool
     */
    public function UpdateImportJobs(\StructType\UpdateImportJobsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateImportJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateVideos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVideosRequest $parameters
     * @return \StructType\UpdateVideosResponse|bool
     */
    public function UpdateVideos(\StructType\UpdateVideosRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateVideos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateAdExtensionsResponse|\StructType\UpdateAdGroupCriterionsResponse|\StructType\UpdateAdGroupsResponse|\StructType\UpdateAdsResponse|\StructType\UpdateAudiencesResponse|\StructType\UpdateBidStrategiesResponse|\StructType\UpdateBudgetsResponse|\StructType\UpdateCampaignCriterionsResponse|\StructType\UpdateCampaignsResponse|\StructType\UpdateConversionGoalsResponse|\StructType\UpdateExperimentsResponse|\StructType\UpdateImportJobsResponse|\StructType\UpdateKeywordsResponse|\StructType\UpdateLabelsResponse|\StructType\UpdateSharedEntitiesResponse|\StructType\UpdateUetTagsResponse|\StructType\UpdateVideosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
