<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $applicationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationToken($applicationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationToken', $applicationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthenticationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $authenticationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationToken($authenticationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationToken', $authenticationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerAccountId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerAccountId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerAccountId($customerAccountId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerAccountId', $customerAccountId, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerId($customerId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerId', $customerId, $mustUnderstand, $actor);
    }
    /**
     * Sets the DeveloperToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $developerToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDeveloperToken($developerToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DeveloperToken', $developerToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the Password SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $password
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassword($password, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Password', $password, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DeleteCampaigns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCampaignsRequest $parameters
     * @return \StructType\DeleteCampaignsResponse|bool
     */
    public function DeleteCampaigns(\StructType\DeleteCampaignsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteCampaigns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAdGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAdGroupsRequest $parameters
     * @return \StructType\DeleteAdGroupsResponse|bool
     */
    public function DeleteAdGroups(\StructType\DeleteAdGroupsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAdGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAdsRequest $parameters
     * @return \StructType\DeleteAdsResponse|bool
     */
    public function DeleteAds(\StructType\DeleteAdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteKeywords
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteKeywordsRequest $parameters
     * @return \StructType\DeleteKeywordsResponse|bool
     */
    public function DeleteKeywords(\StructType\DeleteKeywordsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteKeywords($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAdExtensions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAdExtensionsRequest $parameters
     * @return \StructType\DeleteAdExtensionsResponse|bool
     */
    public function DeleteAdExtensions(\StructType\DeleteAdExtensionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAdExtensions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAdExtensionsAssociations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAdExtensionsAssociationsRequest $parameters
     * @return \StructType\DeleteAdExtensionsAssociationsResponse|bool
     */
    public function DeleteAdExtensionsAssociations(\StructType\DeleteAdExtensionsAssociationsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAdExtensionsAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMedia
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMediaRequest $parameters
     * @return \StructType\DeleteMediaResponse|bool
     */
    public function DeleteMedia(\StructType\DeleteMediaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMedia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAdGroupCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAdGroupCriterionsRequest $parameters
     * @return \StructType\DeleteAdGroupCriterionsResponse|bool
     */
    public function DeleteAdGroupCriterions(\StructType\DeleteAdGroupCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAdGroupCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteNegativeKeywordsFromEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteNegativeKeywordsFromEntitiesRequest $parameters
     * @return \StructType\DeleteNegativeKeywordsFromEntitiesResponse|bool
     */
    public function DeleteNegativeKeywordsFromEntities(\StructType\DeleteNegativeKeywordsFromEntitiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteNegativeKeywordsFromEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteListItemsFromSharedList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteListItemsFromSharedListRequest $parameters
     * @return \StructType\DeleteListItemsFromSharedListResponse|bool
     */
    public function DeleteListItemsFromSharedList(\StructType\DeleteListItemsFromSharedListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteListItemsFromSharedList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSharedEntityAssociations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteSharedEntityAssociationsRequest $parameters
     * @return \StructType\DeleteSharedEntityAssociationsResponse|bool
     */
    public function DeleteSharedEntityAssociations(\StructType\DeleteSharedEntityAssociationsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSharedEntityAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSharedEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteSharedEntitiesRequest $parameters
     * @return \StructType\DeleteSharedEntitiesResponse|bool
     */
    public function DeleteSharedEntities(\StructType\DeleteSharedEntitiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSharedEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCampaignCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCampaignCriterionsRequest $parameters
     * @return \StructType\DeleteCampaignCriterionsResponse|bool
     */
    public function DeleteCampaignCriterions(\StructType\DeleteCampaignCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteCampaignCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteBudgets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteBudgetsRequest $parameters
     * @return \StructType\DeleteBudgetsResponse|bool
     */
    public function DeleteBudgets(\StructType\DeleteBudgetsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteBudgets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteBidStrategies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteBidStrategiesRequest $parameters
     * @return \StructType\DeleteBidStrategiesResponse|bool
     */
    public function DeleteBidStrategies(\StructType\DeleteBidStrategiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteBidStrategies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAudiences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAudiencesRequest $parameters
     * @return \StructType\DeleteAudiencesResponse|bool
     */
    public function DeleteAudiences(\StructType\DeleteAudiencesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAudiences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLabels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLabelsRequest $parameters
     * @return \StructType\DeleteLabelsResponse|bool
     */
    public function DeleteLabels(\StructType\DeleteLabelsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLabelAssociations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLabelAssociationsRequest $parameters
     * @return \StructType\DeleteLabelAssociationsResponse|bool
     */
    public function DeleteLabelAssociations(\StructType\DeleteLabelAssociationsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLabelAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExperiments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteExperimentsRequest $parameters
     * @return \StructType\DeleteExperimentsResponse|bool
     */
    public function DeleteExperiments(\StructType\DeleteExperimentsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteExperiments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteImportJobs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteImportJobsRequest $parameters
     * @return \StructType\DeleteImportJobsResponse|bool
     */
    public function DeleteImportJobs(\StructType\DeleteImportJobsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteImportJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteVideos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteVideosRequest $parameters
     * @return \StructType\DeleteVideosResponse|bool
     */
    public function DeleteVideos(\StructType\DeleteVideosRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteVideos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteAdExtensionsAssociationsResponse|\StructType\DeleteAdExtensionsResponse|\StructType\DeleteAdGroupCriterionsResponse|\StructType\DeleteAdGroupsResponse|\StructType\DeleteAdsResponse|\StructType\DeleteAudiencesResponse|\StructType\DeleteBidStrategiesResponse|\StructType\DeleteBudgetsResponse|\StructType\DeleteCampaignCriterionsResponse|\StructType\DeleteCampaignsResponse|\StructType\DeleteExperimentsResponse|\StructType\DeleteImportJobsResponse|\StructType\DeleteKeywordsResponse|\StructType\DeleteLabelAssociationsResponse|\StructType\DeleteLabelsResponse|\StructType\DeleteListItemsFromSharedListResponse|\StructType\DeleteMediaResponse|\StructType\DeleteNegativeKeywordsFromEntitiesResponse|\StructType\DeleteSharedEntitiesResponse|\StructType\DeleteSharedEntityAssociationsResponse|\StructType\DeleteVideosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
