<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $applicationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationToken($applicationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationToken', $applicationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthenticationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $authenticationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationToken($authenticationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationToken', $authenticationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerAccountId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerAccountId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerAccountId($customerAccountId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerAccountId', $customerAccountId, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerId($customerId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerId', $customerId, $mustUnderstand, $actor);
    }
    /**
     * Sets the DeveloperToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $developerToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDeveloperToken($developerToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DeveloperToken', $developerToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the Password SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $password
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassword($password, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Password', $password, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddCampaigns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCampaignsRequest $parameters
     * @return \StructType\AddCampaignsResponse|bool
     */
    public function AddCampaigns(\StructType\AddCampaignsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCampaigns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdGroupsRequest $parameters
     * @return \StructType\AddAdGroupsResponse|bool
     */
    public function AddAdGroups(\StructType\AddAdGroupsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdsRequest $parameters
     * @return \StructType\AddAdsResponse|bool
     */
    public function AddAds(\StructType\AddAdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddKeywords
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddKeywordsRequest $parameters
     * @return \StructType\AddKeywordsResponse|bool
     */
    public function AddKeywords(\StructType\AddKeywordsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddKeywords($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdExtensions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdExtensionsRequest $parameters
     * @return \StructType\AddAdExtensionsResponse|bool
     */
    public function AddAdExtensions(\StructType\AddAdExtensionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdExtensions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMedia
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMediaRequest $parameters
     * @return \StructType\AddMediaResponse|bool
     */
    public function AddMedia(\StructType\AddMediaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMedia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdGroupCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdGroupCriterionsRequest $parameters
     * @return \StructType\AddAdGroupCriterionsResponse|bool
     */
    public function AddAdGroupCriterions(\StructType\AddAdGroupCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdGroupCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddNegativeKeywordsToEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddNegativeKeywordsToEntitiesRequest $parameters
     * @return \StructType\AddNegativeKeywordsToEntitiesResponse|bool
     */
    public function AddNegativeKeywordsToEntities(\StructType\AddNegativeKeywordsToEntitiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddNegativeKeywordsToEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSharedEntity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSharedEntityRequest $parameters
     * @return \StructType\AddSharedEntityResponse|bool
     */
    public function AddSharedEntity(\StructType\AddSharedEntityRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSharedEntity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddListItemsToSharedList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddListItemsToSharedListRequest $parameters
     * @return \StructType\AddListItemsToSharedListResponse|bool
     */
    public function AddListItemsToSharedList(\StructType\AddListItemsToSharedListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddListItemsToSharedList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCampaignCriterions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCampaignCriterionsRequest $parameters
     * @return \StructType\AddCampaignCriterionsResponse|bool
     */
    public function AddCampaignCriterions(\StructType\AddCampaignCriterionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCampaignCriterions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddBudgets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBudgetsRequest $parameters
     * @return \StructType\AddBudgetsResponse|bool
     */
    public function AddBudgets(\StructType\AddBudgetsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddBudgets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddBidStrategies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBidStrategiesRequest $parameters
     * @return \StructType\AddBidStrategiesResponse|bool
     */
    public function AddBidStrategies(\StructType\AddBidStrategiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddBidStrategies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAudiences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAudiencesRequest $parameters
     * @return \StructType\AddAudiencesResponse|bool
     */
    public function AddAudiences(\StructType\AddAudiencesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAudiences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUetTags
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUetTagsRequest $parameters
     * @return \StructType\AddUetTagsResponse|bool
     */
    public function AddUetTags(\StructType\AddUetTagsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUetTags($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddConversionGoals
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddConversionGoalsRequest $parameters
     * @return \StructType\AddConversionGoalsResponse|bool
     */
    public function AddConversionGoals(\StructType\AddConversionGoalsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddConversionGoals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLabels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLabelsRequest $parameters
     * @return \StructType\AddLabelsResponse|bool
     */
    public function AddLabels(\StructType\AddLabelsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddExperiments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddExperimentsRequest $parameters
     * @return \StructType\AddExperimentsResponse|bool
     */
    public function AddExperiments(\StructType\AddExperimentsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExperiments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddImportJobs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImportJobsRequest $parameters
     * @return \StructType\AddImportJobsResponse|bool
     */
    public function AddImportJobs(\StructType\AddImportJobsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddImportJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddVideos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVideosRequest $parameters
     * @return \StructType\AddVideosResponse|bool
     */
    public function AddVideos(\StructType\AddVideosRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddVideos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAdExtensionsResponse|\StructType\AddAdGroupCriterionsResponse|\StructType\AddAdGroupsResponse|\StructType\AddAdsResponse|\StructType\AddAudiencesResponse|\StructType\AddBidStrategiesResponse|\StructType\AddBudgetsResponse|\StructType\AddCampaignCriterionsResponse|\StructType\AddCampaignsResponse|\StructType\AddConversionGoalsResponse|\StructType\AddExperimentsResponse|\StructType\AddImportJobsResponse|\StructType\AddKeywordsResponse|\StructType\AddLabelsResponse|\StructType\AddListItemsToSharedListResponse|\StructType\AddMediaResponse|\StructType\AddNegativeKeywordsToEntitiesResponse|\StructType\AddSharedEntityResponse|\StructType\AddUetTagsResponse|\StructType\AddVideosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
