<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AppealStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AppealStatus
 * @subpackage Enumerations
 */
class AppealStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Appealable'
     * @return string 'Appealable'
     */
    const VALUE_APPEALABLE = 'Appealable';
    /**
     * Constant for value 'AppealPending'
     * @return string 'AppealPending'
     */
    const VALUE_APPEAL_PENDING = 'AppealPending';
    /**
     * Constant for value 'NotAppealable'
     * @return string 'NotAppealable'
     */
    const VALUE_NOT_APPEALABLE = 'NotAppealable';
    /**
     * Return allowed values
     * @uses self::VALUE_APPEALABLE
     * @uses self::VALUE_APPEAL_PENDING
     * @uses self::VALUE_NOT_APPEALABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPEALABLE,
            self::VALUE_APPEAL_PENDING,
            self::VALUE_NOT_APPEALABLE,
        );
    }
}
