<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSharedListItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSharedListItem
 * @subpackage Arrays
 */
class ArrayOfSharedListItem extends AbstractStructArrayBase
{
    /**
     * The SharedListItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SharedListItem[]
     */
    public $SharedListItem;
    /**
     * Constructor method for ArrayOfSharedListItem
     * @uses ArrayOfSharedListItem::setSharedListItem()
     * @param \StructType\SharedListItem[] $sharedListItem
     */
    public function __construct(array $sharedListItem = array())
    {
        $this
            ->setSharedListItem($sharedListItem);
    }
    /**
     * Get SharedListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SharedListItem[]|null
     */
    public function getSharedListItem()
    {
        return isset($this->SharedListItem) ? $this->SharedListItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSharedListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSharedListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSharedListItemForArrayConstraintsFromSetSharedListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSharedListItemSharedListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSharedListItemSharedListItemItem instanceof \StructType\SharedListItem) {
                $invalidValues[] = is_object($arrayOfSharedListItemSharedListItemItem) ? get_class($arrayOfSharedListItemSharedListItemItem) : sprintf('%s(%s)', gettype($arrayOfSharedListItemSharedListItemItem), var_export($arrayOfSharedListItemSharedListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SharedListItem property can only contain items of type \StructType\SharedListItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SharedListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SharedListItem[] $sharedListItem
     * @return \ArrayType\ArrayOfSharedListItem
     */
    public function setSharedListItem(array $sharedListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($sharedListItemArrayErrorMessage = self::validateSharedListItemForArrayConstraintsFromSetSharedListItem($sharedListItem))) {
            throw new \InvalidArgumentException($sharedListItemArrayErrorMessage, __LINE__);
        }
        if (is_null($sharedListItem) || (is_array($sharedListItem) && empty($sharedListItem))) {
            unset($this->SharedListItem);
        } else {
            $this->SharedListItem = $sharedListItem;
        }
        return $this;
    }
    /**
     * Add item to SharedListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SharedListItem $item
     * @return \ArrayType\ArrayOfSharedListItem
     */
    public function addToSharedListItem(\StructType\SharedListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SharedListItem) {
            throw new \InvalidArgumentException(sprintf('The SharedListItem property can only contain items of type \StructType\SharedListItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SharedListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SharedListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SharedListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SharedListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SharedListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SharedListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SharedListItem
     */
    public function getAttributeName()
    {
        return 'SharedListItem';
    }
}
