<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSetting ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSetting
 * @subpackage Arrays
 */
class ArrayOfSetting extends AbstractStructArrayBase
{
    /**
     * The Setting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Setting[]
     */
    public $Setting;
    /**
     * Constructor method for ArrayOfSetting
     * @uses ArrayOfSetting::setSetting()
     * @param \StructType\Setting[] $setting
     */
    public function __construct(array $setting = array())
    {
        $this
            ->setSetting($setting);
    }
    /**
     * Get Setting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Setting[]|null
     */
    public function getSetting()
    {
        return isset($this->Setting) ? $this->Setting : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSetting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSetting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSettingForArrayConstraintsFromSetSetting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSettingSettingItem) {
            // validation for constraint: itemType
            if (!$arrayOfSettingSettingItem instanceof \StructType\Setting) {
                $invalidValues[] = is_object($arrayOfSettingSettingItem) ? get_class($arrayOfSettingSettingItem) : sprintf('%s(%s)', gettype($arrayOfSettingSettingItem), var_export($arrayOfSettingSettingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Setting property can only contain items of type \StructType\Setting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Setting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Setting[] $setting
     * @return \ArrayType\ArrayOfSetting
     */
    public function setSetting(array $setting = array())
    {
        // validation for constraint: array
        if ('' !== ($settingArrayErrorMessage = self::validateSettingForArrayConstraintsFromSetSetting($setting))) {
            throw new \InvalidArgumentException($settingArrayErrorMessage, __LINE__);
        }
        if (is_null($setting) || (is_array($setting) && empty($setting))) {
            unset($this->Setting);
        } else {
            $this->Setting = $setting;
        }
        return $this;
    }
    /**
     * Add item to Setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Setting $item
     * @return \ArrayType\ArrayOfSetting
     */
    public function addToSetting(\StructType\Setting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Setting) {
            throw new \InvalidArgumentException(sprintf('The Setting property can only contain items of type \StructType\Setting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Setting[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Setting|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Setting|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Setting|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Setting|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Setting|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Setting
     */
    public function getAttributeName()
    {
        return 'Setting';
    }
}
