<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOfflineConversion ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOfflineConversion
 * @subpackage Arrays
 */
class ArrayOfOfflineConversion extends AbstractStructArrayBase
{
    /**
     * The OfflineConversion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OfflineConversion[]
     */
    public $OfflineConversion;
    /**
     * Constructor method for ArrayOfOfflineConversion
     * @uses ArrayOfOfflineConversion::setOfflineConversion()
     * @param \StructType\OfflineConversion[] $offlineConversion
     */
    public function __construct(array $offlineConversion = array())
    {
        $this
            ->setOfflineConversion($offlineConversion);
    }
    /**
     * Get OfflineConversion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OfflineConversion[]|null
     */
    public function getOfflineConversion()
    {
        return isset($this->OfflineConversion) ? $this->OfflineConversion : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOfflineConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfflineConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfflineConversionForArrayConstraintsFromSetOfflineConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOfflineConversionOfflineConversionItem) {
            // validation for constraint: itemType
            if (!$arrayOfOfflineConversionOfflineConversionItem instanceof \StructType\OfflineConversion) {
                $invalidValues[] = is_object($arrayOfOfflineConversionOfflineConversionItem) ? get_class($arrayOfOfflineConversionOfflineConversionItem) : sprintf('%s(%s)', gettype($arrayOfOfflineConversionOfflineConversionItem), var_export($arrayOfOfflineConversionOfflineConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfflineConversion property can only contain items of type \StructType\OfflineConversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfflineConversion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OfflineConversion[] $offlineConversion
     * @return \ArrayType\ArrayOfOfflineConversion
     */
    public function setOfflineConversion(array $offlineConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($offlineConversionArrayErrorMessage = self::validateOfflineConversionForArrayConstraintsFromSetOfflineConversion($offlineConversion))) {
            throw new \InvalidArgumentException($offlineConversionArrayErrorMessage, __LINE__);
        }
        if (is_null($offlineConversion) || (is_array($offlineConversion) && empty($offlineConversion))) {
            unset($this->OfflineConversion);
        } else {
            $this->OfflineConversion = $offlineConversion;
        }
        return $this;
    }
    /**
     * Add item to OfflineConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\OfflineConversion $item
     * @return \ArrayType\ArrayOfOfflineConversion
     */
    public function addToOfflineConversion(\StructType\OfflineConversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfflineConversion) {
            throw new \InvalidArgumentException(sprintf('The OfflineConversion property can only contain items of type \StructType\OfflineConversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfflineConversion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OfflineConversion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OfflineConversion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OfflineConversion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OfflineConversion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OfflineConversion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OfflineConversion
     */
    public function getAttributeName()
    {
        return 'OfflineConversion';
    }
}
