<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMediaMetaData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMediaMetaData
 * @subpackage Arrays
 */
class ArrayOfMediaMetaData extends AbstractStructArrayBase
{
    /**
     * The MediaMetaData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MediaMetaData[]
     */
    public $MediaMetaData;
    /**
     * Constructor method for ArrayOfMediaMetaData
     * @uses ArrayOfMediaMetaData::setMediaMetaData()
     * @param \StructType\MediaMetaData[] $mediaMetaData
     */
    public function __construct(array $mediaMetaData = array())
    {
        $this
            ->setMediaMetaData($mediaMetaData);
    }
    /**
     * Get MediaMetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MediaMetaData[]|null
     */
    public function getMediaMetaData()
    {
        return isset($this->MediaMetaData) ? $this->MediaMetaData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaMetaData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaMetaData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaMetaDataForArrayConstraintsFromSetMediaMetaData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMediaMetaDataMediaMetaDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfMediaMetaDataMediaMetaDataItem instanceof \StructType\MediaMetaData) {
                $invalidValues[] = is_object($arrayOfMediaMetaDataMediaMetaDataItem) ? get_class($arrayOfMediaMetaDataMediaMetaDataItem) : sprintf('%s(%s)', gettype($arrayOfMediaMetaDataMediaMetaDataItem), var_export($arrayOfMediaMetaDataMediaMetaDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaMetaData property can only contain items of type \StructType\MediaMetaData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaMetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaMetaData[] $mediaMetaData
     * @return \ArrayType\ArrayOfMediaMetaData
     */
    public function setMediaMetaData(array $mediaMetaData = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaMetaDataArrayErrorMessage = self::validateMediaMetaDataForArrayConstraintsFromSetMediaMetaData($mediaMetaData))) {
            throw new \InvalidArgumentException($mediaMetaDataArrayErrorMessage, __LINE__);
        }
        if (is_null($mediaMetaData) || (is_array($mediaMetaData) && empty($mediaMetaData))) {
            unset($this->MediaMetaData);
        } else {
            $this->MediaMetaData = $mediaMetaData;
        }
        return $this;
    }
    /**
     * Add item to MediaMetaData value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaMetaData $item
     * @return \ArrayType\ArrayOfMediaMetaData
     */
    public function addToMediaMetaData(\StructType\MediaMetaData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaMetaData) {
            throw new \InvalidArgumentException(sprintf('The MediaMetaData property can only contain items of type \StructType\MediaMetaData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaMetaData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MediaMetaData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MediaMetaData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MediaMetaData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MediaMetaData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MediaMetaData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MediaMetaData
     */
    public function getAttributeName()
    {
        return 'MediaMetaData';
    }
}
