<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMedia ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMedia
 * @subpackage Arrays
 */
class ArrayOfMedia extends AbstractStructArrayBase
{
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Media[]
     */
    public $Media;
    /**
     * Constructor method for ArrayOfMedia
     * @uses ArrayOfMedia::setMedia()
     * @param \StructType\Media[] $media
     */
    public function __construct(array $media = array())
    {
        $this
            ->setMedia($media);
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Media[]|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaForArrayConstraintsFromSetMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMediaMediaItem) {
            // validation for constraint: itemType
            if (!$arrayOfMediaMediaItem instanceof \StructType\Media) {
                $invalidValues[] = is_object($arrayOfMediaMediaItem) ? get_class($arrayOfMediaMediaItem) : sprintf('%s(%s)', gettype($arrayOfMediaMediaItem), var_export($arrayOfMediaMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Media property can only contain items of type \StructType\Media, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Media[] $media
     * @return \ArrayType\ArrayOfMedia
     */
    public function setMedia(array $media = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaArrayErrorMessage = self::validateMediaForArrayConstraintsFromSetMedia($media))) {
            throw new \InvalidArgumentException($mediaArrayErrorMessage, __LINE__);
        }
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Add item to Media value
     * @throws \InvalidArgumentException
     * @param \StructType\Media $item
     * @return \ArrayType\ArrayOfMedia
     */
    public function addToMedia(\StructType\Media $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Media) {
            throw new \InvalidArgumentException(sprintf('The Media property can only contain items of type \StructType\Media, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Media[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Media|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Media|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Media|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Media|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Media|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Media
     */
    public function getAttributeName()
    {
        return 'Media';
    }
}
