<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLabelAssociation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLabelAssociation
 * @subpackage Arrays
 */
class ArrayOfLabelAssociation extends AbstractStructArrayBase
{
    /**
     * The LabelAssociation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LabelAssociation[]
     */
    public $LabelAssociation;
    /**
     * Constructor method for ArrayOfLabelAssociation
     * @uses ArrayOfLabelAssociation::setLabelAssociation()
     * @param \StructType\LabelAssociation[] $labelAssociation
     */
    public function __construct(array $labelAssociation = array())
    {
        $this
            ->setLabelAssociation($labelAssociation);
    }
    /**
     * Get LabelAssociation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LabelAssociation[]|null
     */
    public function getLabelAssociation()
    {
        return isset($this->LabelAssociation) ? $this->LabelAssociation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelAssociationForArrayConstraintsFromSetLabelAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLabelAssociationLabelAssociationItem) {
            // validation for constraint: itemType
            if (!$arrayOfLabelAssociationLabelAssociationItem instanceof \StructType\LabelAssociation) {
                $invalidValues[] = is_object($arrayOfLabelAssociationLabelAssociationItem) ? get_class($arrayOfLabelAssociationLabelAssociationItem) : sprintf('%s(%s)', gettype($arrayOfLabelAssociationLabelAssociationItem), var_export($arrayOfLabelAssociationLabelAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelAssociation property can only contain items of type \StructType\LabelAssociation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelAssociation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LabelAssociation[] $labelAssociation
     * @return \ArrayType\ArrayOfLabelAssociation
     */
    public function setLabelAssociation(array $labelAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($labelAssociationArrayErrorMessage = self::validateLabelAssociationForArrayConstraintsFromSetLabelAssociation($labelAssociation))) {
            throw new \InvalidArgumentException($labelAssociationArrayErrorMessage, __LINE__);
        }
        if (is_null($labelAssociation) || (is_array($labelAssociation) && empty($labelAssociation))) {
            unset($this->LabelAssociation);
        } else {
            $this->LabelAssociation = $labelAssociation;
        }
        return $this;
    }
    /**
     * Add item to LabelAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\LabelAssociation $item
     * @return \ArrayType\ArrayOfLabelAssociation
     */
    public function addToLabelAssociation(\StructType\LabelAssociation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LabelAssociation) {
            throw new \InvalidArgumentException(sprintf('The LabelAssociation property can only contain items of type \StructType\LabelAssociation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LabelAssociation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LabelAssociation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LabelAssociation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LabelAssociation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LabelAssociation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LabelAssociation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LabelAssociation
     */
    public function getAttributeName()
    {
        return 'LabelAssociation';
    }
}
