<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdCollection ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfIdCollection
 * @subpackage Arrays
 */
class ArrayOfIdCollection extends AbstractStructArrayBase
{
    /**
     * The IdCollection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdCollection[]
     */
    public $IdCollection;
    /**
     * Constructor method for ArrayOfIdCollection
     * @uses ArrayOfIdCollection::setIdCollection()
     * @param \StructType\IdCollection[] $idCollection
     */
    public function __construct(array $idCollection = array())
    {
        $this
            ->setIdCollection($idCollection);
    }
    /**
     * Get IdCollection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdCollection[]|null
     */
    public function getIdCollection()
    {
        return isset($this->IdCollection) ? $this->IdCollection : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdCollection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdCollectionForArrayConstraintsFromSetIdCollection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdCollectionIdCollectionItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdCollectionIdCollectionItem instanceof \StructType\IdCollection) {
                $invalidValues[] = is_object($arrayOfIdCollectionIdCollectionItem) ? get_class($arrayOfIdCollectionIdCollectionItem) : sprintf('%s(%s)', gettype($arrayOfIdCollectionIdCollectionItem), var_export($arrayOfIdCollectionIdCollectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdCollection property can only contain items of type \StructType\IdCollection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdCollection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdCollection[] $idCollection
     * @return \ArrayType\ArrayOfIdCollection
     */
    public function setIdCollection(array $idCollection = array())
    {
        // validation for constraint: array
        if ('' !== ($idCollectionArrayErrorMessage = self::validateIdCollectionForArrayConstraintsFromSetIdCollection($idCollection))) {
            throw new \InvalidArgumentException($idCollectionArrayErrorMessage, __LINE__);
        }
        if (is_null($idCollection) || (is_array($idCollection) && empty($idCollection))) {
            unset($this->IdCollection);
        } else {
            $this->IdCollection = $idCollection;
        }
        return $this;
    }
    /**
     * Add item to IdCollection value
     * @throws \InvalidArgumentException
     * @param \StructType\IdCollection $item
     * @return \ArrayType\ArrayOfIdCollection
     */
    public function addToIdCollection(\StructType\IdCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdCollection) {
            throw new \InvalidArgumentException(sprintf('The IdCollection property can only contain items of type \StructType\IdCollection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdCollection[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdCollection|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdCollection|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdCollection|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdCollection|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdCollection|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdCollection
     */
    public function getAttributeName()
    {
        return 'IdCollection';
    }
}
