<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExperiment ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfExperiment
 * @subpackage Arrays
 */
class ArrayOfExperiment extends AbstractStructArrayBase
{
    /**
     * The Experiment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Experiment[]
     */
    public $Experiment;
    /**
     * Constructor method for ArrayOfExperiment
     * @uses ArrayOfExperiment::setExperiment()
     * @param \StructType\Experiment[] $experiment
     */
    public function __construct(array $experiment = array())
    {
        $this
            ->setExperiment($experiment);
    }
    /**
     * Get Experiment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Experiment[]|null
     */
    public function getExperiment()
    {
        return isset($this->Experiment) ? $this->Experiment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExperiment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExperiment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExperimentForArrayConstraintsFromSetExperiment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfExperimentExperimentItem) {
            // validation for constraint: itemType
            if (!$arrayOfExperimentExperimentItem instanceof \StructType\Experiment) {
                $invalidValues[] = is_object($arrayOfExperimentExperimentItem) ? get_class($arrayOfExperimentExperimentItem) : sprintf('%s(%s)', gettype($arrayOfExperimentExperimentItem), var_export($arrayOfExperimentExperimentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Experiment property can only contain items of type \StructType\Experiment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Experiment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Experiment[] $experiment
     * @return \ArrayType\ArrayOfExperiment
     */
    public function setExperiment(array $experiment = array())
    {
        // validation for constraint: array
        if ('' !== ($experimentArrayErrorMessage = self::validateExperimentForArrayConstraintsFromSetExperiment($experiment))) {
            throw new \InvalidArgumentException($experimentArrayErrorMessage, __LINE__);
        }
        if (is_null($experiment) || (is_array($experiment) && empty($experiment))) {
            unset($this->Experiment);
        } else {
            $this->Experiment = $experiment;
        }
        return $this;
    }
    /**
     * Add item to Experiment value
     * @throws \InvalidArgumentException
     * @param \StructType\Experiment $item
     * @return \ArrayType\ArrayOfExperiment
     */
    public function addToExperiment(\StructType\Experiment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Experiment) {
            throw new \InvalidArgumentException(sprintf('The Experiment property can only contain items of type \StructType\Experiment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Experiment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Experiment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Experiment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Experiment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Experiment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Experiment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Experiment
     */
    public function getAttributeName()
    {
        return 'Experiment';
    }
}
