<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDayTime ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDayTime
 * @subpackage Arrays
 */
class ArrayOfDayTime extends AbstractStructArrayBase
{
    /**
     * The DayTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DayTime[]
     */
    public $DayTime;
    /**
     * Constructor method for ArrayOfDayTime
     * @uses ArrayOfDayTime::setDayTime()
     * @param \StructType\DayTime[] $dayTime
     */
    public function __construct(array $dayTime = array())
    {
        $this
            ->setDayTime($dayTime);
    }
    /**
     * Get DayTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DayTime[]|null
     */
    public function getDayTime()
    {
        return isset($this->DayTime) ? $this->DayTime : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDayTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDayTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDayTimeForArrayConstraintsFromSetDayTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDayTimeDayTimeItem) {
            // validation for constraint: itemType
            if (!$arrayOfDayTimeDayTimeItem instanceof \StructType\DayTime) {
                $invalidValues[] = is_object($arrayOfDayTimeDayTimeItem) ? get_class($arrayOfDayTimeDayTimeItem) : sprintf('%s(%s)', gettype($arrayOfDayTimeDayTimeItem), var_export($arrayOfDayTimeDayTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DayTime property can only contain items of type \StructType\DayTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DayTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DayTime[] $dayTime
     * @return \ArrayType\ArrayOfDayTime
     */
    public function setDayTime(array $dayTime = array())
    {
        // validation for constraint: array
        if ('' !== ($dayTimeArrayErrorMessage = self::validateDayTimeForArrayConstraintsFromSetDayTime($dayTime))) {
            throw new \InvalidArgumentException($dayTimeArrayErrorMessage, __LINE__);
        }
        if (is_null($dayTime) || (is_array($dayTime) && empty($dayTime))) {
            unset($this->DayTime);
        } else {
            $this->DayTime = $dayTime;
        }
        return $this;
    }
    /**
     * Add item to DayTime value
     * @throws \InvalidArgumentException
     * @param \StructType\DayTime $item
     * @return \ArrayType\ArrayOfDayTime
     */
    public function addToDayTime(\StructType\DayTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DayTime) {
            throw new \InvalidArgumentException(sprintf('The DayTime property can only contain items of type \StructType\DayTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DayTime[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DayTime|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DayTime|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DayTime|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DayTime|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DayTime|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DayTime
     */
    public function getAttributeName()
    {
        return 'DayTime';
    }
}
