<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomParameter ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomParameter
 * @subpackage Arrays
 */
class ArrayOfCustomParameter extends AbstractStructArrayBase
{
    /**
     * The CustomParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameter[]
     */
    public $CustomParameter;
    /**
     * Constructor method for ArrayOfCustomParameter
     * @uses ArrayOfCustomParameter::setCustomParameter()
     * @param \StructType\CustomParameter[] $customParameter
     */
    public function __construct(array $customParameter = array())
    {
        $this
            ->setCustomParameter($customParameter);
    }
    /**
     * Get CustomParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameter[]|null
     */
    public function getCustomParameter()
    {
        return isset($this->CustomParameter) ? $this->CustomParameter : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomParameterForArrayConstraintsFromSetCustomParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomParameterCustomParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomParameterCustomParameterItem instanceof \StructType\CustomParameter) {
                $invalidValues[] = is_object($arrayOfCustomParameterCustomParameterItem) ? get_class($arrayOfCustomParameterCustomParameterItem) : sprintf('%s(%s)', gettype($arrayOfCustomParameterCustomParameterItem), var_export($arrayOfCustomParameterCustomParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomParameter property can only contain items of type \StructType\CustomParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomParameter[] $customParameter
     * @return \ArrayType\ArrayOfCustomParameter
     */
    public function setCustomParameter(array $customParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($customParameterArrayErrorMessage = self::validateCustomParameterForArrayConstraintsFromSetCustomParameter($customParameter))) {
            throw new \InvalidArgumentException($customParameterArrayErrorMessage, __LINE__);
        }
        if (is_null($customParameter) || (is_array($customParameter) && empty($customParameter))) {
            unset($this->CustomParameter);
        } else {
            $this->CustomParameter = $customParameter;
        }
        return $this;
    }
    /**
     * Add item to CustomParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomParameter $item
     * @return \ArrayType\ArrayOfCustomParameter
     */
    public function addToCustomParameter(\StructType\CustomParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomParameter) {
            throw new \InvalidArgumentException(sprintf('The CustomParameter property can only contain items of type \StructType\CustomParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomParameter
     */
    public function getAttributeName()
    {
        return 'CustomParameter';
    }
}
