<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCampaign ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCampaign
 * @subpackage Arrays
 */
class ArrayOfCampaign extends AbstractStructArrayBase
{
    /**
     * The Campaign
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Campaign[]
     */
    public $Campaign;
    /**
     * Constructor method for ArrayOfCampaign
     * @uses ArrayOfCampaign::setCampaign()
     * @param \StructType\Campaign[] $campaign
     */
    public function __construct(array $campaign = array())
    {
        $this
            ->setCampaign($campaign);
    }
    /**
     * Get Campaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Campaign[]|null
     */
    public function getCampaign()
    {
        return isset($this->Campaign) ? $this->Campaign : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaign method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaign method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignForArrayConstraintsFromSetCampaign(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCampaignCampaignItem) {
            // validation for constraint: itemType
            if (!$arrayOfCampaignCampaignItem instanceof \StructType\Campaign) {
                $invalidValues[] = is_object($arrayOfCampaignCampaignItem) ? get_class($arrayOfCampaignCampaignItem) : sprintf('%s(%s)', gettype($arrayOfCampaignCampaignItem), var_export($arrayOfCampaignCampaignItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Campaign property can only contain items of type \StructType\Campaign, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Campaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Campaign[] $campaign
     * @return \ArrayType\ArrayOfCampaign
     */
    public function setCampaign(array $campaign = array())
    {
        // validation for constraint: array
        if ('' !== ($campaignArrayErrorMessage = self::validateCampaignForArrayConstraintsFromSetCampaign($campaign))) {
            throw new \InvalidArgumentException($campaignArrayErrorMessage, __LINE__);
        }
        if (is_null($campaign) || (is_array($campaign) && empty($campaign))) {
            unset($this->Campaign);
        } else {
            $this->Campaign = $campaign;
        }
        return $this;
    }
    /**
     * Add item to Campaign value
     * @throws \InvalidArgumentException
     * @param \StructType\Campaign $item
     * @return \ArrayType\ArrayOfCampaign
     */
    public function addToCampaign(\StructType\Campaign $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Campaign) {
            throw new \InvalidArgumentException(sprintf('The Campaign property can only contain items of type \StructType\Campaign, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Campaign[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Campaign|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Campaign|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Campaign|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Campaign|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Campaign|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Campaign
     */
    public function getAttributeName()
    {
        return 'Campaign';
    }
}
