<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAppUrl ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAppUrl
 * @subpackage Arrays
 */
class ArrayOfAppUrl extends AbstractStructArrayBase
{
    /**
     * The AppUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AppUrl[]
     */
    public $AppUrl;
    /**
     * Constructor method for ArrayOfAppUrl
     * @uses ArrayOfAppUrl::setAppUrl()
     * @param \StructType\AppUrl[] $appUrl
     */
    public function __construct(array $appUrl = array())
    {
        $this
            ->setAppUrl($appUrl);
    }
    /**
     * Get AppUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AppUrl[]|null
     */
    public function getAppUrl()
    {
        return isset($this->AppUrl) ? $this->AppUrl : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAppUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAppUrl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAppUrlForArrayConstraintsFromSetAppUrl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAppUrlAppUrlItem) {
            // validation for constraint: itemType
            if (!$arrayOfAppUrlAppUrlItem instanceof \StructType\AppUrl) {
                $invalidValues[] = is_object($arrayOfAppUrlAppUrlItem) ? get_class($arrayOfAppUrlAppUrlItem) : sprintf('%s(%s)', gettype($arrayOfAppUrlAppUrlItem), var_export($arrayOfAppUrlAppUrlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AppUrl property can only contain items of type \StructType\AppUrl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AppUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AppUrl[] $appUrl
     * @return \ArrayType\ArrayOfAppUrl
     */
    public function setAppUrl(array $appUrl = array())
    {
        // validation for constraint: array
        if ('' !== ($appUrlArrayErrorMessage = self::validateAppUrlForArrayConstraintsFromSetAppUrl($appUrl))) {
            throw new \InvalidArgumentException($appUrlArrayErrorMessage, __LINE__);
        }
        if (is_null($appUrl) || (is_array($appUrl) && empty($appUrl))) {
            unset($this->AppUrl);
        } else {
            $this->AppUrl = $appUrl;
        }
        return $this;
    }
    /**
     * Add item to AppUrl value
     * @throws \InvalidArgumentException
     * @param \StructType\AppUrl $item
     * @return \ArrayType\ArrayOfAppUrl
     */
    public function addToAppUrl(\StructType\AppUrl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AppUrl) {
            throw new \InvalidArgumentException(sprintf('The AppUrl property can only contain items of type \StructType\AppUrl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AppUrl[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AppUrl|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AppUrl|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AppUrl|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AppUrl|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AppUrl|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AppUrl
     */
    public function getAttributeName()
    {
        return 'AppUrl';
    }
}
