<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdGroupCriterion ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAdGroupCriterion
 * @subpackage Arrays
 */
class ArrayOfAdGroupCriterion extends AbstractStructArrayBase
{
    /**
     * The AdGroupCriterion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdGroupCriterion[]
     */
    public $AdGroupCriterion;
    /**
     * Constructor method for ArrayOfAdGroupCriterion
     * @uses ArrayOfAdGroupCriterion::setAdGroupCriterion()
     * @param \StructType\AdGroupCriterion[] $adGroupCriterion
     */
    public function __construct(array $adGroupCriterion = array())
    {
        $this
            ->setAdGroupCriterion($adGroupCriterion);
    }
    /**
     * Get AdGroupCriterion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdGroupCriterion[]|null
     */
    public function getAdGroupCriterion()
    {
        return isset($this->AdGroupCriterion) ? $this->AdGroupCriterion : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupCriterion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupCriterion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupCriterionForArrayConstraintsFromSetAdGroupCriterion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdGroupCriterionAdGroupCriterionItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdGroupCriterionAdGroupCriterionItem instanceof \StructType\AdGroupCriterion) {
                $invalidValues[] = is_object($arrayOfAdGroupCriterionAdGroupCriterionItem) ? get_class($arrayOfAdGroupCriterionAdGroupCriterionItem) : sprintf('%s(%s)', gettype($arrayOfAdGroupCriterionAdGroupCriterionItem), var_export($arrayOfAdGroupCriterionAdGroupCriterionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdGroupCriterion property can only contain items of type \StructType\AdGroupCriterion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupCriterion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdGroupCriterion[] $adGroupCriterion
     * @return \ArrayType\ArrayOfAdGroupCriterion
     */
    public function setAdGroupCriterion(array $adGroupCriterion = array())
    {
        // validation for constraint: array
        if ('' !== ($adGroupCriterionArrayErrorMessage = self::validateAdGroupCriterionForArrayConstraintsFromSetAdGroupCriterion($adGroupCriterion))) {
            throw new \InvalidArgumentException($adGroupCriterionArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupCriterion) || (is_array($adGroupCriterion) && empty($adGroupCriterion))) {
            unset($this->AdGroupCriterion);
        } else {
            $this->AdGroupCriterion = $adGroupCriterion;
        }
        return $this;
    }
    /**
     * Add item to AdGroupCriterion value
     * @throws \InvalidArgumentException
     * @param \StructType\AdGroupCriterion $item
     * @return \ArrayType\ArrayOfAdGroupCriterion
     */
    public function addToAdGroupCriterion(\StructType\AdGroupCriterion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdGroupCriterion) {
            throw new \InvalidArgumentException(sprintf('The AdGroupCriterion property can only contain items of type \StructType\AdGroupCriterion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdGroupCriterion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdGroupCriterion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdGroupCriterion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdGroupCriterion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdGroupCriterion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdGroupCriterion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdGroupCriterion
     */
    public function getAttributeName()
    {
        return 'AdGroupCriterion';
    }
}
