<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdGroup ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAdGroup
 * @subpackage Arrays
 */
class ArrayOfAdGroup extends AbstractStructArrayBase
{
    /**
     * The AdGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdGroup[]
     */
    public $AdGroup;
    /**
     * Constructor method for ArrayOfAdGroup
     * @uses ArrayOfAdGroup::setAdGroup()
     * @param \StructType\AdGroup[] $adGroup
     */
    public function __construct(array $adGroup = array())
    {
        $this
            ->setAdGroup($adGroup);
    }
    /**
     * Get AdGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdGroup[]|null
     */
    public function getAdGroup()
    {
        return isset($this->AdGroup) ? $this->AdGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupForArrayConstraintsFromSetAdGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdGroupAdGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdGroupAdGroupItem instanceof \StructType\AdGroup) {
                $invalidValues[] = is_object($arrayOfAdGroupAdGroupItem) ? get_class($arrayOfAdGroupAdGroupItem) : sprintf('%s(%s)', gettype($arrayOfAdGroupAdGroupItem), var_export($arrayOfAdGroupAdGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdGroup property can only contain items of type \StructType\AdGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdGroup[] $adGroup
     * @return \ArrayType\ArrayOfAdGroup
     */
    public function setAdGroup(array $adGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($adGroupArrayErrorMessage = self::validateAdGroupForArrayConstraintsFromSetAdGroup($adGroup))) {
            throw new \InvalidArgumentException($adGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroup) || (is_array($adGroup) && empty($adGroup))) {
            unset($this->AdGroup);
        } else {
            $this->AdGroup = $adGroup;
        }
        return $this;
    }
    /**
     * Add item to AdGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\AdGroup $item
     * @return \ArrayType\ArrayOfAdGroup
     */
    public function addToAdGroup(\StructType\AdGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdGroup) {
            throw new \InvalidArgumentException(sprintf('The AdGroup property can only contain items of type \StructType\AdGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdGroup
     */
    public function getAttributeName()
    {
        return 'AdGroup';
    }
}
