<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAVResponse UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressXAVResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups_address\UPSaddressStruct\Ups_addressResponseType
     */
    public $Response;
    /**
     * The ValidAddressIndicator
     * Meta information extracted from the WSDL
     * - choice: ValidAddressIndicator | AmbiguousAddressIndicator | NoCandidatesIndicator
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $ValidAddressIndicator;
    /**
     * The AmbiguousAddressIndicator
     * Meta information extracted from the WSDL
     * - choice: ValidAddressIndicator | AmbiguousAddressIndicator | NoCandidatesIndicator
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $AmbiguousAddressIndicator;
    /**
     * The NoCandidatesIndicator
     * Meta information extracted from the WSDL
     * - choice: ValidAddressIndicator | AmbiguousAddressIndicator | NoCandidatesIndicator
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $NoCandidatesIndicator;
    /**
     * The AddressClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType
     */
    public $AddressClassification;
    /**
     * The Candidate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressCandidateType[]
     */
    public $Candidate;
    /**
     * Constructor method for XAVResponse
     * @uses Ups_addressXAVResponse::setResponse()
     * @uses Ups_addressXAVResponse::setValidAddressIndicator()
     * @uses Ups_addressXAVResponse::setAmbiguousAddressIndicator()
     * @uses Ups_addressXAVResponse::setNoCandidatesIndicator()
     * @uses Ups_addressXAVResponse::setAddressClassification()
     * @uses Ups_addressXAVResponse::setCandidate()
     * @param \Ups_address\UPSaddressStruct\Ups_addressResponseType $response
     * @param string $validAddressIndicator
     * @param string $ambiguousAddressIndicator
     * @param string $noCandidatesIndicator
     * @param \Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType $addressClassification
     * @param \Ups_address\UPSaddressStruct\Ups_addressCandidateType[] $candidate
     */
    public function __construct(\Ups_address\UPSaddressStruct\Ups_addressResponseType $response = null, $validAddressIndicator = null, $ambiguousAddressIndicator = null, $noCandidatesIndicator = null, \Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType $addressClassification = null, array $candidate = array())
    {
        $this
            ->setResponse($response)
            ->setValidAddressIndicator($validAddressIndicator)
            ->setAmbiguousAddressIndicator($ambiguousAddressIndicator)
            ->setNoCandidatesIndicator($noCandidatesIndicator)
            ->setAddressClassification($addressClassification)
            ->setCandidate($candidate);
    }
    /**
     * Get Response value
     * @return \Ups_address\UPSaddressStruct\Ups_addressResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups_address\UPSaddressStruct\Ups_addressResponseType $response
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setResponse(\Ups_address\UPSaddressStruct\Ups_addressResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ValidAddressIndicator value
     * @return string|null
     */
    public function getValidAddressIndicator()
    {
        return isset($this->ValidAddressIndicator) ? $this->ValidAddressIndicator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setValidAddressIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidAddressIndicator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateValidAddressIndicatorForChoiceConstraintsFromSetValidAddressIndicator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AmbiguousAddressIndicator',
            'NoCandidatesIndicator',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ValidAddressIndicator can\'t be set as the property %s is already set. Only one property must be set among these properties: ValidAddressIndicator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ValidAddressIndicator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $validAddressIndicator
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setValidAddressIndicator($validAddressIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($validAddressIndicator) && !is_string($validAddressIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAddressIndicator, true), gettype($validAddressIndicator)), __LINE__);
        }
        // validation for constraint: choice(ValidAddressIndicator, AmbiguousAddressIndicator, NoCandidatesIndicator)
        if ('' !== ($validAddressIndicatorChoiceErrorMessage = self::validateValidAddressIndicatorForChoiceConstraintsFromSetValidAddressIndicator($validAddressIndicator))) {
            throw new \InvalidArgumentException($validAddressIndicatorChoiceErrorMessage, __LINE__);
        }
        if (is_null($validAddressIndicator) || (is_array($validAddressIndicator) && empty($validAddressIndicator))) {
            unset($this->ValidAddressIndicator);
        } else {
            $this->ValidAddressIndicator = $validAddressIndicator;
        }
        return $this;
    }
    /**
     * Get AmbiguousAddressIndicator value
     * @return string|null
     */
    public function getAmbiguousAddressIndicator()
    {
        return isset($this->AmbiguousAddressIndicator) ? $this->AmbiguousAddressIndicator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmbiguousAddressIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmbiguousAddressIndicator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmbiguousAddressIndicatorForChoiceConstraintsFromSetAmbiguousAddressIndicator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ValidAddressIndicator',
            'NoCandidatesIndicator',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AmbiguousAddressIndicator can\'t be set as the property %s is already set. Only one property must be set among these properties: AmbiguousAddressIndicator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AmbiguousAddressIndicator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ambiguousAddressIndicator
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setAmbiguousAddressIndicator($ambiguousAddressIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($ambiguousAddressIndicator) && !is_string($ambiguousAddressIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ambiguousAddressIndicator, true), gettype($ambiguousAddressIndicator)), __LINE__);
        }
        // validation for constraint: choice(ValidAddressIndicator, AmbiguousAddressIndicator, NoCandidatesIndicator)
        if ('' !== ($ambiguousAddressIndicatorChoiceErrorMessage = self::validateAmbiguousAddressIndicatorForChoiceConstraintsFromSetAmbiguousAddressIndicator($ambiguousAddressIndicator))) {
            throw new \InvalidArgumentException($ambiguousAddressIndicatorChoiceErrorMessage, __LINE__);
        }
        if (is_null($ambiguousAddressIndicator) || (is_array($ambiguousAddressIndicator) && empty($ambiguousAddressIndicator))) {
            unset($this->AmbiguousAddressIndicator);
        } else {
            $this->AmbiguousAddressIndicator = $ambiguousAddressIndicator;
        }
        return $this;
    }
    /**
     * Get NoCandidatesIndicator value
     * @return string|null
     */
    public function getNoCandidatesIndicator()
    {
        return isset($this->NoCandidatesIndicator) ? $this->NoCandidatesIndicator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNoCandidatesIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNoCandidatesIndicator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNoCandidatesIndicatorForChoiceConstraintsFromSetNoCandidatesIndicator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ValidAddressIndicator',
            'AmbiguousAddressIndicator',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NoCandidatesIndicator can\'t be set as the property %s is already set. Only one property must be set among these properties: NoCandidatesIndicator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NoCandidatesIndicator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $noCandidatesIndicator
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setNoCandidatesIndicator($noCandidatesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($noCandidatesIndicator) && !is_string($noCandidatesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noCandidatesIndicator, true), gettype($noCandidatesIndicator)), __LINE__);
        }
        // validation for constraint: choice(ValidAddressIndicator, AmbiguousAddressIndicator, NoCandidatesIndicator)
        if ('' !== ($noCandidatesIndicatorChoiceErrorMessage = self::validateNoCandidatesIndicatorForChoiceConstraintsFromSetNoCandidatesIndicator($noCandidatesIndicator))) {
            throw new \InvalidArgumentException($noCandidatesIndicatorChoiceErrorMessage, __LINE__);
        }
        if (is_null($noCandidatesIndicator) || (is_array($noCandidatesIndicator) && empty($noCandidatesIndicator))) {
            unset($this->NoCandidatesIndicator);
        } else {
            $this->NoCandidatesIndicator = $noCandidatesIndicator;
        }
        return $this;
    }
    /**
     * Get AddressClassification value
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType|null
     */
    public function getAddressClassification()
    {
        return $this->AddressClassification;
    }
    /**
     * Set AddressClassification value
     * @param \Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType $addressClassification
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setAddressClassification(\Ups_address\UPSaddressStruct\Ups_addressAddressClassificationType $addressClassification = null)
    {
        $this->AddressClassification = $addressClassification;
        return $this;
    }
    /**
     * Get Candidate value
     * @return \Ups_address\UPSaddressStruct\Ups_addressCandidateType[]|null
     */
    public function getCandidate()
    {
        return $this->Candidate;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidateForArrayConstraintsFromSetCandidate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xAVResponseCandidateItem) {
            // validation for constraint: itemType
            if (!$xAVResponseCandidateItem instanceof \Ups_address\UPSaddressStruct\Ups_addressCandidateType) {
                $invalidValues[] = is_object($xAVResponseCandidateItem) ? get_class($xAVResponseCandidateItem) : sprintf('%s(%s)', gettype($xAVResponseCandidateItem), var_export($xAVResponseCandidateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCandidateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCandidateType[] $candidate
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function setCandidate(array $candidate = array())
    {
        // validation for constraint: array
        if ('' !== ($candidateArrayErrorMessage = self::validateCandidateForArrayConstraintsFromSetCandidate($candidate))) {
            throw new \InvalidArgumentException($candidateArrayErrorMessage, __LINE__);
        }
        $this->Candidate = $candidate;
        return $this;
    }
    /**
     * Add item to Candidate value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCandidateType $item
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function addToCandidate(\Ups_address\UPSaddressStruct\Ups_addressCandidateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_address\UPSaddressStruct\Ups_addressCandidateType) {
            throw new \InvalidArgumentException(sprintf('The Candidate property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCandidateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate[] = $item;
        return $this;
    }
}
