<?php

namespace Ups_address\UPSaddressService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPSaddressService
 * @package Ups_address
 * @subpackage Services
 */
class Ups_addressProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_address\UPSaddressStruct\Ups_addressUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_address\UPSaddressStruct\Ups_addressUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessXAV
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_address\UPSaddressStruct\Ups_addressUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_address\UPSaddressStruct\Ups_addressXAVRequest $body
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse|bool
     */
    public function ProcessXAV(\Ups_address\UPSaddressStruct\Ups_addressXAVRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessXAV($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
