<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_addressResponseType::setResponseStatus()
     * @uses Ups_addressResponseType::setAlert()
     * @uses Ups_addressResponseType::setTransactionReference()
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $responseStatus
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType[] $alert
     * @param \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $responseStatus = null, array $alert = array(), \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $responseStatus
     * @return \Ups_address\UPSaddressStruct\Ups_addressResponseType
     */
    public function setResponseStatus(\Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType[] $alert
     * @return \Ups_address\UPSaddressStruct\Ups_addressResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $item
     * @return \Ups_address\UPSaddressStruct\Ups_addressResponseType
     */
    public function addToAlert(\Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference
     * @return \Ups_address\UPSaddressStruct\Ups_addressResponseType
     */
    public function setTransactionReference(\Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
