<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressKeyFormatType UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressAddressKeyFormatType extends AbstractStructBase
{
    /**
     * The ConsigneeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeName;
    /**
     * The AttentionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttentionName;
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The PoliticalDivision2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PoliticalDivision2;
    /**
     * The PoliticalDivision1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PoliticalDivision1;
    /**
     * The PostcodePrimaryLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostcodePrimaryLow;
    /**
     * The PostcodeExtendedLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostcodeExtendedLow;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Urbanization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Urbanization;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for AddressKeyFormatType
     * @uses Ups_addressAddressKeyFormatType::setConsigneeName()
     * @uses Ups_addressAddressKeyFormatType::setAttentionName()
     * @uses Ups_addressAddressKeyFormatType::setAddressLine()
     * @uses Ups_addressAddressKeyFormatType::setPoliticalDivision2()
     * @uses Ups_addressAddressKeyFormatType::setPoliticalDivision1()
     * @uses Ups_addressAddressKeyFormatType::setPostcodePrimaryLow()
     * @uses Ups_addressAddressKeyFormatType::setPostcodeExtendedLow()
     * @uses Ups_addressAddressKeyFormatType::setRegion()
     * @uses Ups_addressAddressKeyFormatType::setUrbanization()
     * @uses Ups_addressAddressKeyFormatType::setCountryCode()
     * @param string $consigneeName
     * @param string $attentionName
     * @param string[] $addressLine
     * @param string $politicalDivision2
     * @param string $politicalDivision1
     * @param string $postcodePrimaryLow
     * @param string $postcodeExtendedLow
     * @param string $region
     * @param string $urbanization
     * @param string $countryCode
     */
    public function __construct($consigneeName = null, $attentionName = null, array $addressLine = array(), $politicalDivision2 = null, $politicalDivision1 = null, $postcodePrimaryLow = null, $postcodeExtendedLow = null, $region = null, $urbanization = null, $countryCode = null)
    {
        $this
            ->setConsigneeName($consigneeName)
            ->setAttentionName($attentionName)
            ->setAddressLine($addressLine)
            ->setPoliticalDivision2($politicalDivision2)
            ->setPoliticalDivision1($politicalDivision1)
            ->setPostcodePrimaryLow($postcodePrimaryLow)
            ->setPostcodeExtendedLow($postcodeExtendedLow)
            ->setRegion($region)
            ->setUrbanization($urbanization)
            ->setCountryCode($countryCode);
    }
    /**
     * Get ConsigneeName value
     * @return string|null
     */
    public function getConsigneeName()
    {
        return $this->ConsigneeName;
    }
    /**
     * Set ConsigneeName value
     * @param string $consigneeName
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setConsigneeName($consigneeName = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeName) && !is_string($consigneeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeName, true), gettype($consigneeName)), __LINE__);
        }
        $this->ConsigneeName = $consigneeName;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressKeyFormatTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressKeyFormatTypeAddressLineItem)) {
                $invalidValues[] = is_object($addressKeyFormatTypeAddressLineItem) ? get_class($addressKeyFormatTypeAddressLineItem) : sprintf('%s(%s)', gettype($addressKeyFormatTypeAddressLineItem), var_export($addressKeyFormatTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get PoliticalDivision2 value
     * @return string|null
     */
    public function getPoliticalDivision2()
    {
        return $this->PoliticalDivision2;
    }
    /**
     * Set PoliticalDivision2 value
     * @param string $politicalDivision2
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setPoliticalDivision2($politicalDivision2 = null)
    {
        // validation for constraint: string
        if (!is_null($politicalDivision2) && !is_string($politicalDivision2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($politicalDivision2, true), gettype($politicalDivision2)), __LINE__);
        }
        $this->PoliticalDivision2 = $politicalDivision2;
        return $this;
    }
    /**
     * Get PoliticalDivision1 value
     * @return string|null
     */
    public function getPoliticalDivision1()
    {
        return $this->PoliticalDivision1;
    }
    /**
     * Set PoliticalDivision1 value
     * @param string $politicalDivision1
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setPoliticalDivision1($politicalDivision1 = null)
    {
        // validation for constraint: string
        if (!is_null($politicalDivision1) && !is_string($politicalDivision1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($politicalDivision1, true), gettype($politicalDivision1)), __LINE__);
        }
        $this->PoliticalDivision1 = $politicalDivision1;
        return $this;
    }
    /**
     * Get PostcodePrimaryLow value
     * @return string|null
     */
    public function getPostcodePrimaryLow()
    {
        return $this->PostcodePrimaryLow;
    }
    /**
     * Set PostcodePrimaryLow value
     * @param string $postcodePrimaryLow
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setPostcodePrimaryLow($postcodePrimaryLow = null)
    {
        // validation for constraint: string
        if (!is_null($postcodePrimaryLow) && !is_string($postcodePrimaryLow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcodePrimaryLow, true), gettype($postcodePrimaryLow)), __LINE__);
        }
        $this->PostcodePrimaryLow = $postcodePrimaryLow;
        return $this;
    }
    /**
     * Get PostcodeExtendedLow value
     * @return string|null
     */
    public function getPostcodeExtendedLow()
    {
        return $this->PostcodeExtendedLow;
    }
    /**
     * Set PostcodeExtendedLow value
     * @param string $postcodeExtendedLow
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setPostcodeExtendedLow($postcodeExtendedLow = null)
    {
        // validation for constraint: string
        if (!is_null($postcodeExtendedLow) && !is_string($postcodeExtendedLow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcodeExtendedLow, true), gettype($postcodeExtendedLow)), __LINE__);
        }
        $this->PostcodeExtendedLow = $postcodeExtendedLow;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Urbanization value
     * @return string|null
     */
    public function getUrbanization()
    {
        return $this->Urbanization;
    }
    /**
     * Set Urbanization value
     * @param string $urbanization
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setUrbanization($urbanization = null)
    {
        // validation for constraint: string
        if (!is_null($urbanization) && !is_string($urbanization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urbanization, true), gettype($urbanization)), __LINE__);
        }
        $this->Urbanization = $urbanization;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
