<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAVRequest UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressXAVRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_address\UPSaddressStruct\Ups_addressRequestType
     */
    public $Request;
    /**
     * The RegionalRequestIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegionalRequestIndicator;
    /**
     * The MaximumCandidateListSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaximumCandidateListSize;
    /**
     * The AddressKeyFormat
     * @var \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType
     */
    public $AddressKeyFormat;
    /**
     * Constructor method for XAVRequest
     * @uses Ups_addressXAVRequest::setRequest()
     * @uses Ups_addressXAVRequest::setRegionalRequestIndicator()
     * @uses Ups_addressXAVRequest::setMaximumCandidateListSize()
     * @uses Ups_addressXAVRequest::setAddressKeyFormat()
     * @param \Ups_address\UPSaddressStruct\Ups_addressRequestType $request
     * @param string $regionalRequestIndicator
     * @param string $maximumCandidateListSize
     * @param \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType $addressKeyFormat
     */
    public function __construct(\Ups_address\UPSaddressStruct\Ups_addressRequestType $request = null, $regionalRequestIndicator = null, $maximumCandidateListSize = null, \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType $addressKeyFormat = null)
    {
        $this
            ->setRequest($request)
            ->setRegionalRequestIndicator($regionalRequestIndicator)
            ->setMaximumCandidateListSize($maximumCandidateListSize)
            ->setAddressKeyFormat($addressKeyFormat);
    }
    /**
     * Get Request value
     * @return \Ups_address\UPSaddressStruct\Ups_addressRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_address\UPSaddressStruct\Ups_addressRequestType $request
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVRequest
     */
    public function setRequest(\Ups_address\UPSaddressStruct\Ups_addressRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get RegionalRequestIndicator value
     * @return string|null
     */
    public function getRegionalRequestIndicator()
    {
        return $this->RegionalRequestIndicator;
    }
    /**
     * Set RegionalRequestIndicator value
     * @param string $regionalRequestIndicator
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVRequest
     */
    public function setRegionalRequestIndicator($regionalRequestIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($regionalRequestIndicator) && !is_string($regionalRequestIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionalRequestIndicator, true), gettype($regionalRequestIndicator)), __LINE__);
        }
        $this->RegionalRequestIndicator = $regionalRequestIndicator;
        return $this;
    }
    /**
     * Get MaximumCandidateListSize value
     * @return string|null
     */
    public function getMaximumCandidateListSize()
    {
        return $this->MaximumCandidateListSize;
    }
    /**
     * Set MaximumCandidateListSize value
     * @param string $maximumCandidateListSize
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVRequest
     */
    public function setMaximumCandidateListSize($maximumCandidateListSize = null)
    {
        // validation for constraint: string
        if (!is_null($maximumCandidateListSize) && !is_string($maximumCandidateListSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumCandidateListSize, true), gettype($maximumCandidateListSize)), __LINE__);
        }
        $this->MaximumCandidateListSize = $maximumCandidateListSize;
        return $this;
    }
    /**
     * Get AddressKeyFormat value
     * @return \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType|null
     */
    public function getAddressKeyFormat()
    {
        return $this->AddressKeyFormat;
    }
    /**
     * Set AddressKeyFormat value
     * @param \Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType $addressKeyFormat
     * @return \Ups_address\UPSaddressStruct\Ups_addressXAVRequest
     */
    public function setAddressKeyFormat(\Ups_address\UPSaddressStruct\Ups_addressAddressKeyFormatType $addressKeyFormat = null)
    {
        $this->AddressKeyFormat = $addressKeyFormat;
        return $this;
    }
}
