<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestType UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressRequestType extends AbstractStructBase
{
    /**
     * The RequestOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RequestOption;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for RequestType
     * @uses Ups_addressRequestType::setRequestOption()
     * @uses Ups_addressRequestType::setTransactionReference()
     * @param string[] $requestOption
     * @param \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference
     */
    public function __construct(array $requestOption = array(), \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setRequestOption($requestOption)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get RequestOption value
     * @return string[]|null
     */
    public function getRequestOption()
    {
        return $this->RequestOption;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestOptionForArrayConstraintsFromSetRequestOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestTypeRequestOptionItem) {
            // validation for constraint: itemType
            if (!is_string($requestTypeRequestOptionItem)) {
                $invalidValues[] = is_object($requestTypeRequestOptionItem) ? get_class($requestTypeRequestOptionItem) : sprintf('%s(%s)', gettype($requestTypeRequestOptionItem), var_export($requestTypeRequestOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RequestOption property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequestOption value
     * @throws \InvalidArgumentException
     * @param string[] $requestOption
     * @return \Ups_address\UPSaddressStruct\Ups_addressRequestType
     */
    public function setRequestOption(array $requestOption = array())
    {
        // validation for constraint: array
        if ('' !== ($requestOptionArrayErrorMessage = self::validateRequestOptionForArrayConstraintsFromSetRequestOption($requestOption))) {
            throw new \InvalidArgumentException($requestOptionArrayErrorMessage, __LINE__);
        }
        $this->RequestOption = $requestOption;
        return $this;
    }
    /**
     * Add item to RequestOption value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_address\UPSaddressStruct\Ups_addressRequestType
     */
    public function addToRequestOption($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RequestOption property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RequestOption[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference
     * @return \Ups_address\UPSaddressStruct\Ups_addressRequestType
     */
    public function setTransactionReference(\Ups_address\UPSaddressStruct\Ups_addressTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
